/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v1_1.domain;

import com.google.common.base.Objects;
import java.net.URI;
import java.util.Date;
import org.jclouds.openstack.domain.Resource;

public class Extension
extends Resource {
    private URI namespace;
    private String alias;
    private Date updated;
    private String description;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromExtension(this);
    }

    protected Extension() {
    }

    protected Extension(Builder<?> builder) {
        super(builder);
        this.namespace = ((Builder)builder).namespace;
        this.alias = ((Builder)builder).alias;
        this.updated = ((Builder)builder).updated;
        this.description = ((Builder)builder).description;
    }

    public URI getNamespace() {
        return this.namespace;
    }

    public String getId() {
        return this.alias;
    }

    public String getAlias() {
        return this.alias;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public String getDescription() {
        return this.description;
    }

    public Objects.ToStringHelper string() {
        return super.string().add("namespace", (Object)this.namespace).add("alias", (Object)this.alias).add("updated", (Object)this.updated).add("description", (Object)this.description);
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>>
    extends Resource.Builder<T> {
        private URI namespace;
        private String alias;
        private Date updated;
        private String description;

        public T namespace(URI namespace) {
            this.namespace = namespace;
            return (T)((Object)((Builder)this.self()));
        }

        public T alias(String alias) {
            this.id(alias);
            this.alias = alias;
            return (T)((Object)((Builder)this.self()));
        }

        public T updated(Date updated) {
            this.updated = updated;
            return (T)((Object)((Builder)this.self()));
        }

        public T description(String description) {
            this.description = description;
            return (T)((Object)((Builder)this.self()));
        }

        public Extension build() {
            return new Extension(this);
        }

        public T fromExtension(Extension in) {
            return ((Builder)((Object)((Builder)((Object)((Builder)((Object)((Builder)super.fromResource((Resource)in)).namespace(in.getNamespace()))).alias(in.getAlias()))).updated(in.getUpdated()))).description(in.getDescription());
        }
    }
}

