/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v1_1.domain;

import com.google.common.base.Objects;
import com.google.gson.annotations.SerializedName;
import org.jclouds.javax.annotation.Nullable;

public class FloatingIP
implements Comparable<FloatingIP> {
    private String id;
    private String ip;
    @SerializedName(value="fixed_ip")
    private String fixedIp;
    @SerializedName(value="instance_id")
    private String instanceId;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return FloatingIP.builder().fromFloatingIp(this);
    }

    protected FloatingIP() {
    }

    protected FloatingIP(String id, String ip, @Nullable String fixedIp, @Nullable String instanceId) {
        this.id = id;
        this.ip = ip;
        this.fixedIp = fixedIp;
        this.instanceId = instanceId;
    }

    public String getId() {
        return this.id;
    }

    public String getIp() {
        return this.ip;
    }

    public String getFixedIp() {
        return this.fixedIp;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    @Override
    public int compareTo(FloatingIP o) {
        return this.id.compareTo(o.getId());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fixedIp == null ? 0 : this.fixedIp.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.instanceId == null ? 0 : this.instanceId.hashCode());
        result = 31 * result + (this.ip == null ? 0 : this.ip.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FloatingIP other = (FloatingIP)obj;
        if (this.fixedIp == null ? other.fixedIp != null : !this.fixedIp.equals(other.fixedIp)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.instanceId == null ? other.instanceId != null : !this.instanceId.equals(other.instanceId)) {
            return false;
        }
        return !(this.ip == null ? other.ip != null : !this.ip.equals(other.ip));
    }

    public String toString() {
        return Objects.toStringHelper((String)"").add("id", (Object)this.id).add("ip", (Object)this.ip).add("fixedIp", (Object)this.fixedIp).add("instanceId", (Object)this.instanceId).toString();
    }

    public static class Builder {
        private String id;
        private String ip;
        private String fixedIp;
        private String instanceId;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder ip(String ip) {
            this.ip = ip;
            return this;
        }

        public Builder fixedIp(String fixedIp) {
            this.fixedIp = fixedIp;
            return this;
        }

        public Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public FloatingIP build() {
            return new FloatingIP(this.id, this.ip, this.fixedIp, this.instanceId);
        }

        public Builder fromFloatingIp(FloatingIP in) {
            return this.id(in.getId()).ip(in.getIp()).fixedIp(in.getFixedIp()).instanceId(in.getInstanceId());
        }
    }
}

