/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v1_1.domain;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.annotations.SerializedName;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Set;

public class HostAggregate {
    private String id;
    private String name;
    @SerializedName(value="availability_zone")
    private String availabilityZone;
    private Set<String> hosts = ImmutableSet.of();
    @SerializedName(value="operational_state")
    private String state;
    @SerializedName(value="created_at")
    private Date created;
    @SerializedName(value="updated_at")
    private Optional<Date> updated = Optional.absent();
    private Map<String, String> metadata = ImmutableMap.of();

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromAggregate(this);
    }

    protected HostAggregate() {
    }

    protected HostAggregate(Builder<?> builder) {
        this.id = (String)Preconditions.checkNotNull((Object)((Builder)builder).id, (Object)"id");
        this.name = (String)Preconditions.checkNotNull((Object)((Builder)builder).name, (Object)"name");
        this.availabilityZone = (String)Preconditions.checkNotNull((Object)((Builder)builder).availabilityZone, (Object)"availabilityZone");
        this.hosts = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull((Object)((Builder)builder).hosts, (Object)"hosts")));
        this.state = (String)Preconditions.checkNotNull((Object)((Builder)builder).state, (Object)"state");
        this.created = (Date)Preconditions.checkNotNull((Object)((Builder)builder).created, (Object)"created");
        this.updated = Optional.fromNullable((Object)((Builder)builder).updated);
        this.metadata = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull((Object)((Builder)builder).metadata, (Object)"metadata")));
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public Set<String> getHosts() {
        return Collections.unmodifiableSet(this.hosts);
    }

    public String getState() {
        return this.state;
    }

    public Date getCreated() {
        return this.created;
    }

    public Optional<Date> getUpdated() {
        return this.updated;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.name, this.availabilityZone, this.hosts, this.state, this.created, this.updated, this.metadata});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HostAggregate that = (HostAggregate)HostAggregate.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.availabilityZone, (Object)that.availabilityZone) && Objects.equal(this.hosts, that.hosts) && Objects.equal((Object)this.state, (Object)that.state) && Objects.equal((Object)this.created, (Object)that.created) && Objects.equal(this.updated, that.updated) && Objects.equal(this.metadata, that.metadata);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((String)"").add("id", (Object)this.id).add("name", (Object)this.name).add("availabilityZone", (Object)this.availabilityZone).add("hosts", this.hosts).add("state", (Object)this.state).add("created", (Object)this.created).add("updated", this.updated).add("metadata", this.metadata);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        private String id;
        private String name;
        private String availabilityZone;
        private Set<String> hosts = ImmutableSet.of();
        private String state;
        private Date created = new Date();
        private Date updated;
        private Map<String, String> metadata = ImmutableMap.of();

        protected abstract T self();

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this.self();
        }

        public T hosts(String ... hosts) {
            return this.hosts((Set<String>)ImmutableSet.copyOf((Object[])hosts));
        }

        public T hosts(Set<String> hosts) {
            this.hosts = hosts;
            return this.self();
        }

        public T state(String state) {
            this.state = state;
            return this.self();
        }

        public T created(Date created) {
            this.created = created;
            return this.self();
        }

        public T updated(Date updated) {
            this.updated = updated;
            return this.self();
        }

        public T metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this.self();
        }

        public HostAggregate build() {
            return new HostAggregate(this);
        }

        public T fromAggregate(HostAggregate in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id(in.getId())).name(in.getName())).availabilityZone(in.getAvailabilityZone())).hosts(in.getHosts())).state(in.getState())).created(in.getCreated())).updated((Date)in.getUpdated().orNull())).metadata(in.getMetadata());
        }
    }
}

