/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v1_1.domain;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.annotations.SerializedName;
import java.util.Date;
import java.util.Map;
import org.jclouds.openstack.domain.Resource;

public class Image
extends Resource {
    private Date updated;
    private Date created;
    @SerializedName(value="tenant_id")
    private String tenantId;
    @SerializedName(value="user_id")
    private String userId;
    private Status status;
    private int progress;
    private int minDisk;
    private int minRam;
    private Resource server;
    private Map<String, String> metadata = ImmutableMap.of();

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromImage(this);
    }

    protected Image() {
    }

    protected Image(Builder<?> builder) {
        super(builder);
        this.updated = ((Builder)builder).updated;
        this.created = ((Builder)builder).created;
        this.tenantId = ((Builder)builder).tenantId;
        this.userId = ((Builder)builder).userId;
        this.status = ((Builder)builder).status;
        this.progress = ((Builder)builder).progress;
        this.minDisk = ((Builder)builder).minDisk;
        this.minRam = ((Builder)builder).minRam;
        this.server = ((Builder)builder).server;
        this.metadata = ImmutableMap.copyOf((Map)((Builder)builder).metadata);
    }

    public Date getUpdated() {
        return this.updated;
    }

    public Date getCreated() {
        return this.created;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getUserId() {
        return this.userId;
    }

    public Status getStatus() {
        return this.status;
    }

    public int getProgress() {
        return this.progress;
    }

    public int getMinDisk() {
        return this.minDisk;
    }

    public int getMinRam() {
        return this.minRam;
    }

    public Resource getServer() {
        return this.server;
    }

    public Map<String, String> getMetadata() {
        return ImmutableMap.copyOf((Map)Maps.filterValues(this.metadata, (Predicate)Predicates.notNull()));
    }

    protected Objects.ToStringHelper string() {
        return super.string().add("updated", (Object)this.updated).add("created", (Object)this.created).add("tenantId", (Object)this.tenantId).add("userId", (Object)this.userId).add("status", (Object)this.status).add("progress", this.progress).add("minDisk", this.minDisk).add("minRam", this.minRam).add("server", (Object)this.server).add("metadata", this.metadata);
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>>
    extends Resource.Builder<T> {
        private Date updated;
        private Date created;
        private String tenantId;
        private String userId;
        private Status status;
        private int progress;
        private int minDisk;
        private int minRam;
        private Resource server;
        private Map<String, String> metadata = ImmutableMap.of();

        public T updated(Date updated) {
            this.updated = updated;
            return (T)((Object)((Builder)this.self()));
        }

        public T created(Date created) {
            this.created = created;
            return (T)((Object)((Builder)this.self()));
        }

        public T tenantId(String tenantId) {
            this.tenantId = tenantId;
            return (T)((Object)((Builder)this.self()));
        }

        public T userId(String userId) {
            this.userId = userId;
            return (T)((Object)((Builder)this.self()));
        }

        public T status(Status status) {
            this.status = status;
            return (T)((Object)((Builder)this.self()));
        }

        public T progress(int progress) {
            this.progress = progress;
            return (T)((Object)((Builder)this.self()));
        }

        public T minDisk(int minDisk) {
            this.minDisk = minDisk;
            return (T)((Object)((Builder)this.self()));
        }

        public T minRam(int minRam) {
            this.minRam = minRam;
            return (T)((Object)((Builder)this.self()));
        }

        public T server(Resource server) {
            this.server = server;
            return (T)((Object)((Builder)this.self()));
        }

        public T metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return (T)((Object)((Builder)this.self()));
        }

        public Image build() {
            return new Image(this);
        }

        public T fromImage(Image in) {
            return ((Builder)((Object)((Builder)((Object)((Builder)((Object)((Builder)((Object)((Builder)((Object)((Builder)((Object)((Builder)((Object)((Builder)((Object)((Builder)((Object)((Builder)super.fromResource((Resource)in)).updated(in.getUpdated()))).created(in.getCreated()))).tenantId(in.getTenantId()))).userId(in.getUserId()))).status(in.getStatus()))).progress(in.getProgress()))).minDisk(in.getMinDisk()))).minRam(in.getMinRam()))).server(in.getServer()))).metadata(in.getMetadata());
        }
    }

    public static enum Status {
        UNRECOGNIZED,
        UNKNOWN,
        ACTIVE,
        SAVING,
        ERROR,
        DELETED;


        public String value() {
            return this.name();
        }

        public static Status fromValue(String v) {
            try {
                return Status.valueOf(v);
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

