/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v1_1.domain;

import com.google.common.base.Objects;
import com.google.gson.annotations.SerializedName;
import org.jclouds.javax.annotation.Nullable;

public class KeyPair
implements Comparable<KeyPair> {
    @SerializedName(value="public_key")
    private String publicKey;
    @SerializedName(value="private_key")
    private String privateKey;
    @SerializedName(value="user_id")
    private String userId;
    private String name;
    private String fingerprint;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return KeyPair.builder().fromKeyPair(this);
    }

    protected KeyPair() {
    }

    protected KeyPair(String publicKey, String privateKey, @Nullable String userId, String name, String fingerprint) {
        this.publicKey = publicKey;
        this.privateKey = privateKey;
        this.userId = userId;
        this.name = name;
        this.fingerprint = fingerprint;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public String getUserId() {
        return this.privateKey;
    }

    public String getName() {
        return this.name;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    @Override
    public int compareTo(KeyPair o) {
        return this.fingerprint.compareTo(o.getFingerprint());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.publicKey == null ? 0 : this.publicKey.hashCode());
        result = 31 * result + (this.privateKey == null ? 0 : this.privateKey.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.fingerprint == null ? 0 : this.fingerprint.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KeyPair other = (KeyPair)obj;
        if (this.publicKey == null ? other.publicKey != null : !this.publicKey.equals(other.publicKey)) {
            return false;
        }
        if (this.privateKey == null ? other.privateKey != null : !this.privateKey.equals(other.privateKey)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.fingerprint == null ? other.fingerprint != null : !this.fingerprint.equals(other.fingerprint));
    }

    public String toString() {
        return Objects.toStringHelper((String)"").add("userId", (Object)this.userId).add("name", (Object)this.name).add("fingerprint", (Object)this.fingerprint).toString();
    }

    public static class Builder {
        private String publicKey;
        private String privateKey;
        private String userId;
        private String name;
        private String fingerprint;

        public Builder publicKey(String publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        public Builder privateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder fingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
            return this;
        }

        public KeyPair build() {
            return new KeyPair(this.publicKey, this.privateKey, this.userId, this.name, this.fingerprint);
        }

        public Builder fromKeyPair(KeyPair in) {
            return this.publicKey(in.getPublicKey()).privateKey(in.getPrivateKey()).userId(in.getUserId()).name(in.getName()).fingerprint(in.getFingerprint());
        }
    }
}

