/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v1_1.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.gson.annotations.SerializedName;

public class Quotas {
    @SerializedName(value="id")
    private String id;
    @SerializedName(value="metadata_items")
    private int metadataItems;
    @SerializedName(value="injected_file_content_bytes")
    private int injectedFileContentBytes;
    private int volumes;
    private int gigabytes;
    private int ram;
    @SerializedName(value="floating_ips")
    private int floatingIps;
    private int instances;
    @SerializedName(value="injected_files")
    private int injectedFiles;
    private int cores;
    @SerializedName(value="security_groups")
    private int securityGroups;
    @SerializedName(value="security_group_rules")
    private int securityGroupRules;
    @SerializedName(value="key_pairs")
    private int keyPairs;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromQuotas(this);
    }

    protected Quotas() {
    }

    protected Quotas(Builder<?> builder) {
        this.id = (String)Preconditions.checkNotNull((Object)((Builder)builder).id, (Object)"id");
        this.metadataItems = (Integer)Preconditions.checkNotNull((Object)((Builder)builder).metadataItems, (Object)"metadataItems");
        this.injectedFileContentBytes = (Integer)Preconditions.checkNotNull((Object)((Builder)builder).injectedFileContentBytes, (Object)"injectedFileContentBytes");
        this.volumes = (Integer)Preconditions.checkNotNull((Object)((Builder)builder).volumes, (Object)"volumes");
        this.gigabytes = (Integer)Preconditions.checkNotNull((Object)((Builder)builder).gigabytes, (Object)"gigabytes");
        this.ram = (Integer)Preconditions.checkNotNull((Object)((Builder)builder).ram, (Object)"ram");
        this.floatingIps = (Integer)Preconditions.checkNotNull((Object)((Builder)builder).floatingIps, (Object)"floatingIps");
        this.instances = (Integer)Preconditions.checkNotNull((Object)((Builder)builder).instances, (Object)"instances");
        this.injectedFiles = (Integer)Preconditions.checkNotNull((Object)((Builder)builder).injectedFiles, (Object)"injectedFiles");
        this.cores = (Integer)Preconditions.checkNotNull((Object)((Builder)builder).cores, (Object)"cores");
        this.securityGroups = (Integer)Preconditions.checkNotNull((Object)((Builder)builder).securityGroups, (Object)"securityGroups");
        this.securityGroupRules = (Integer)Preconditions.checkNotNull((Object)((Builder)builder).securityGroupRules, (Object)"securityGroupRules");
        this.keyPairs = (Integer)Preconditions.checkNotNull((Object)((Builder)builder).keyPairs, (Object)"keyPairs");
    }

    public String getId() {
        return this.id;
    }

    public int getMetadataItems() {
        return this.metadataItems;
    }

    public int getInjectedFileContentBytes() {
        return this.injectedFileContentBytes;
    }

    public int getVolumes() {
        return this.volumes;
    }

    public int getGigabytes() {
        return this.gigabytes;
    }

    public int getRam() {
        return this.ram;
    }

    public int getFloatingIps() {
        return this.floatingIps;
    }

    public int getInstances() {
        return this.instances;
    }

    public int getInjectedFiles() {
        return this.injectedFiles;
    }

    public int getCores() {
        return this.cores;
    }

    public int getSecurityGroups() {
        return this.securityGroups;
    }

    public int getSecurityGroupRules() {
        return this.securityGroupRules;
    }

    public int getKeyPairs() {
        return this.keyPairs;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.metadataItems, this.injectedFileContentBytes, this.volumes, this.gigabytes, this.ram, this.floatingIps, this.instances, this.injectedFiles, this.cores, this.securityGroups, this.securityGroupRules, this.keyPairs});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Quotas that = (Quotas)Quotas.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.metadataItems, (Object)that.metadataItems) && Objects.equal((Object)this.injectedFileContentBytes, (Object)that.injectedFileContentBytes) && Objects.equal((Object)this.volumes, (Object)that.volumes) && Objects.equal((Object)this.gigabytes, (Object)that.gigabytes) && Objects.equal((Object)this.ram, (Object)that.ram) && Objects.equal((Object)this.floatingIps, (Object)that.floatingIps) && Objects.equal((Object)this.instances, (Object)that.instances) && Objects.equal((Object)this.injectedFiles, (Object)that.injectedFiles) && Objects.equal((Object)this.cores, (Object)that.cores) && Objects.equal((Object)this.securityGroups, (Object)that.securityGroups) && Objects.equal((Object)this.securityGroupRules, (Object)that.securityGroupRules) && Objects.equal((Object)this.keyPairs, (Object)that.keyPairs);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((String)"").add("id", (Object)this.id).add("metadataItems", this.metadataItems).add("injectedFileContentBytes", this.injectedFileContentBytes).add("volumes", this.volumes).add("gigabytes", this.gigabytes).add("ram", this.ram).add("floatingIps", this.floatingIps).add("instances", this.instances).add("injectedFiles", this.injectedFiles).add("cores", this.cores).add("securityGroups", this.securityGroups).add("securityGroupRules", this.securityGroupRules).add("keyPairs", this.keyPairs);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        private String id;
        private int metadataItems;
        private int injectedFileContentBytes;
        private int volumes;
        private int gigabytes;
        private int ram;
        private int floatingIps;
        private int instances;
        private int injectedFiles;
        private int cores;
        private int securityGroups;
        private int securityGroupRules;
        private int keyPairs;

        protected abstract T self();

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T metadataItems(int metadataItems) {
            this.metadataItems = metadataItems;
            return this.self();
        }

        public T injectedFileContentBytes(int injectedFileContentBytes) {
            this.injectedFileContentBytes = injectedFileContentBytes;
            return this.self();
        }

        public T volumes(int volumes) {
            this.volumes = volumes;
            return this.self();
        }

        public T gigabytes(int gigabytes) {
            this.gigabytes = gigabytes;
            return this.self();
        }

        public T ram(int ram) {
            this.ram = ram;
            return this.self();
        }

        public T floatingIps(int floatingIps) {
            this.floatingIps = floatingIps;
            return this.self();
        }

        public T instances(int instances) {
            this.instances = instances;
            return this.self();
        }

        public T injectedFiles(int injectedFiles) {
            this.injectedFiles = injectedFiles;
            return this.self();
        }

        public T cores(int cores) {
            this.cores = cores;
            return this.self();
        }

        public T securityGroups(int securityGroups) {
            this.securityGroups = securityGroups;
            return this.self();
        }

        public T securityGroupRules(int securityGroupRules) {
            this.securityGroupRules = securityGroupRules;
            return this.self();
        }

        public T keyPairs(int keyPairs) {
            this.keyPairs = keyPairs;
            return this.self();
        }

        public Quotas build() {
            return new Quotas(this);
        }

        public T fromQuotas(Quotas in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id(in.getId())).metadataItems(in.getMetadataItems())).injectedFileContentBytes(in.getInjectedFileContentBytes())).volumes(in.getVolumes())).gigabytes(in.getGigabytes())).ram(in.getRam())).floatingIps(in.getFloatingIps())).instances(in.getInstances())).injectedFiles(in.getInjectedFiles())).cores(in.getCores())).securityGroups(in.getSecurityGroups())).securityGroupRules(in.getSecurityGroupRules())).keyPairs(in.getKeyPairs());
        }
    }
}

