/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v1_1.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingObject;
import com.google.gson.annotations.SerializedName;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.nova.v1_1.domain.Ingress;
import org.jclouds.openstack.nova.v1_1.domain.IpProtocol;
import org.jclouds.openstack.nova.v1_1.domain.TenantIdAndName;

public class SecurityGroupRule
extends Ingress {
    protected String id;
    protected TenantIdAndName group;
    @SerializedName(value="parent_group_id")
    protected String parentGroupId;
    @SerializedName(value="ip_range")
    protected Cidr ipRange;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return SecurityGroupRule.builder().fromSecurityGroupRule(this);
    }

    protected SecurityGroupRule() {
    }

    protected SecurityGroupRule(IpProtocol ipProtocol, int fromPort, int toPort, String id, String parentGroupId, @Nullable TenantIdAndName group, @Nullable String ipRange) {
        super(ipProtocol, fromPort, toPort);
        this.parentGroupId = (String)Preconditions.checkNotNull((Object)parentGroupId, (Object)"parentGroupId");
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.group = group;
        this.ipRange = ipRange != null ? new Cidr(ipRange) : null;
    }

    public String getParentGroupId() {
        return this.parentGroupId;
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public TenantIdAndName getGroup() {
        if (this.group == null || this.group.getName() == null) {
            return null;
        }
        return this.group;
    }

    @Nullable
    public String getIpRange() {
        return this.ipRange == null ? null : this.ipRange.cidr;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.fromPort;
        result = 31 * result + (this.group == null ? 0 : this.group.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.ipProtocol == null ? 0 : this.ipProtocol.hashCode());
        result = 31 * result + (this.ipRange == null ? 0 : ((Object)((Object)this.ipRange)).hashCode());
        result = 31 * result + (this.parentGroupId == null ? 0 : this.parentGroupId.hashCode());
        result = 31 * result + this.toPort;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SecurityGroupRule other = (SecurityGroupRule)obj;
        if (this.fromPort != other.fromPort) {
            return false;
        }
        if (this.group == null ? other.group != null : !this.group.equals(other.group)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.ipProtocol != other.ipProtocol) {
            return false;
        }
        if (this.ipRange == null ? other.ipRange != null : !((Object)((Object)this.ipRange)).equals((Object)other.ipRange)) {
            return false;
        }
        if (this.parentGroupId == null ? other.parentGroupId != null : !this.parentGroupId.equals(other.parentGroupId)) {
            return false;
        }
        return this.toPort == other.toPort;
    }

    @Override
    public String toString() {
        return Objects.toStringHelper((String)"").add("id", (Object)this.id).add("fromPort", this.fromPort).add("group", (Object)this.getGroup()).add("ipProtocol", (Object)this.ipProtocol).add("toPort", this.toPort).add("parentGroupId", (Object)this.parentGroupId).add("ipRange", (Object)this.getIpRange()).toString();
    }

    private static class Cidr
    extends ForwardingObject {
        private String cidr;

        private Cidr(String cidr) {
            this.cidr = cidr;
        }

        protected Object delegate() {
            return this.cidr;
        }
    }

    public static class Builder
    extends Ingress.Builder {
        private String id;
        private String parentGroupId;
        private TenantIdAndName group;
        private String ipRange;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder group(TenantIdAndName group) {
            this.group = group;
            return this;
        }

        public Builder parentGroupId(String parentGroupId) {
            this.parentGroupId = parentGroupId;
            return this;
        }

        public Builder ipRange(String ipRange) {
            this.ipRange = ipRange;
            return this;
        }

        @Override
        public SecurityGroupRule build() {
            return new SecurityGroupRule(this.ipProtocol, this.fromPort, this.toPort, this.id, this.parentGroupId, this.group, this.ipRange);
        }

        public Builder fromSecurityGroupRule(SecurityGroupRule in) {
            return this.id(in.getId()).fromPort(in.getFromPort()).group(in.getGroup()).ipProtocol(in.getIpProtocol()).toPort(in.getToPort()).parentGroupId(in.getParentGroupId()).ipRange(in.getIpRange());
        }

        @Override
        public Builder ipProtocol(IpProtocol ipProtocol) {
            super.ipProtocol(ipProtocol);
            return this;
        }

        @Override
        public Builder fromPort(int fromPort) {
            super.fromPort(fromPort);
            return this;
        }

        @Override
        public Builder toPort(int toPort) {
            super.toPort(toPort);
            return this;
        }
    }
}

