/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v1_1.domain;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.gson.annotations.SerializedName;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.jclouds.compute.domain.NodeState;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.domain.Resource;
import org.jclouds.openstack.nova.v1_1.domain.Address;
import org.jclouds.openstack.nova.v1_1.domain.ServerExtendedAttributes;
import org.jclouds.openstack.nova.v1_1.domain.ServerExtendedStatus;
import org.jclouds.util.Multimaps2;

public class Server
extends Resource {
    private String uuid;
    @SerializedName(value="tenant_id")
    private String tenantId;
    @SerializedName(value="user_id")
    private String userId;
    private Date updated;
    private Date created;
    private String hostId;
    private String accessIPv4;
    private String accessIPv6;
    private Status status;
    private Resource image;
    private Resource flavor;
    @SerializedName(value="key_name")
    private String keyName;
    @SerializedName(value="config_drive")
    private String configDrive;
    private Map<String, Set<Address>> addresses = ImmutableMap.of();
    private Map<String, String> metadata = ImmutableMap.of();
    private Optional<ServerExtendedStatus> extendedStatus = Optional.absent();
    private Optional<ServerExtendedAttributes> extendedAttributes = Optional.absent();
    @SerializedName(value="OS-DCF:diskConfig")
    private Optional<String> diskConfig = Optional.absent();

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromServer(this);
    }

    protected Server() {
    }

    protected Server(Builder<?> builder) {
        super(builder);
        this.uuid = ((Builder)builder).uuid;
        this.tenantId = (String)Preconditions.checkNotNull((Object)((Builder)builder).tenantId, (Object)"tenantId");
        this.userId = (String)Preconditions.checkNotNull((Object)((Builder)builder).userId, (Object)"userId");
        this.updated = (Date)Preconditions.checkNotNull((Object)((Builder)builder).updated, (Object)"updated");
        this.created = (Date)Preconditions.checkNotNull((Object)((Builder)builder).created, (Object)"created");
        this.hostId = ((Builder)builder).hostId;
        this.accessIPv4 = ((Builder)builder).accessIPv4;
        this.accessIPv6 = ((Builder)builder).accessIPv6;
        this.status = (Status)((Object)Preconditions.checkNotNull((Object)((Object)((Builder)builder).status), (Object)"status"));
        this.configDrive = ((Builder)builder).configDrive;
        this.image = (Resource)Preconditions.checkNotNull((Object)((Builder)builder).image, (Object)"image");
        this.flavor = (Resource)Preconditions.checkNotNull((Object)((Builder)builder).flavor, (Object)"flavor");
        this.metadata = Maps.newHashMap((Map)((Builder)builder).metadata);
        this.addresses = Multimaps2.toOldSchool((Multimap)ImmutableMultimap.copyOf((Multimap)((Multimap)Preconditions.checkNotNull((Object)((Builder)builder).addresses, (Object)"addresses"))));
        this.keyName = ((Builder)builder).keyName;
        this.extendedStatus = Optional.fromNullable((Object)((Builder)builder).extendedStatus);
        this.extendedAttributes = Optional.fromNullable((Object)((Builder)builder).extendedAttributes);
        this.diskConfig = ((Builder)builder).diskConfig == null ? Optional.absent() : Optional.of((Object)((Builder)builder).diskConfig);
    }

    @Nullable
    public String getUuid() {
        return this.uuid;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getUserId() {
        return this.userId;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public Date getCreated() {
        return this.created;
    }

    @Nullable
    public String getHostId() {
        return Strings.emptyToNull((String)this.hostId);
    }

    @Nullable
    public String getAccessIPv4() {
        return Strings.emptyToNull((String)this.accessIPv4);
    }

    @Nullable
    public String getAccessIPv6() {
        return Strings.emptyToNull((String)this.accessIPv6);
    }

    public Status getStatus() {
        return this.status;
    }

    @Nullable
    public String getConfigDrive() {
        return Strings.emptyToNull((String)this.configDrive);
    }

    public Resource getImage() {
        return this.image;
    }

    public Resource getFlavor() {
        return this.flavor;
    }

    public Map<String, String> getMetadata() {
        return ImmutableMap.copyOf((Map)Maps.filterValues(this.metadata, (Predicate)Predicates.notNull()));
    }

    public Multimap<String, Address> getAddresses() {
        return Multimaps2.fromOldSchool(this.addresses);
    }

    @Nullable
    public String getKeyName() {
        return this.keyName;
    }

    public Optional<ServerExtendedStatus> getExtendedStatus() {
        return this.extendedStatus;
    }

    public Optional<ServerExtendedAttributes> getExtendedAttributes() {
        return this.extendedAttributes;
    }

    public Optional<String> getDiskConfig() {
        return this.diskConfig;
    }

    protected Objects.ToStringHelper string() {
        return super.string().add("uuid", (Object)this.uuid).add("tenantId", (Object)this.tenantId).add("userId", (Object)this.userId).add("hostId", (Object)this.getHostId()).add("updated", (Object)this.updated).add("created", (Object)this.created).add("accessIPv4", (Object)this.getAccessIPv4()).add("accessIPv6", (Object)this.getAccessIPv6()).add("status", (Object)this.status).add("configDrive", (Object)this.getConfigDrive()).add("image", (Object)this.image).add("flavor", (Object)this.flavor).add("metadata", this.metadata).add("addresses", this.getAddresses()).add("diskConfig", this.diskConfig).add("extendedStatus", this.extendedStatus).add("extendedAttributes", this.extendedAttributes);
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>>
    extends Resource.Builder<T> {
        private String uuid;
        private String tenantId;
        private String userId;
        private Date updated;
        private Date created;
        private String hostId;
        private String accessIPv4;
        private String accessIPv6;
        private Status status;
        private Resource image;
        private Resource flavor;
        private String keyName;
        private String configDrive;
        private Multimap<String, Address> addresses = ImmutableMultimap.of();
        private Map<String, String> metadata = ImmutableMap.of();
        private ServerExtendedStatus extendedStatus;
        private ServerExtendedAttributes extendedAttributes;
        private String diskConfig;

        public T uuid(String uuid) {
            this.uuid = uuid;
            return (T)((Object)((Builder)this.self()));
        }

        public T tenantId(String tenantId) {
            this.tenantId = tenantId;
            return (T)((Object)((Builder)this.self()));
        }

        public T userId(String userId) {
            this.userId = userId;
            return (T)((Object)((Builder)this.self()));
        }

        public T updated(Date updated) {
            this.updated = updated;
            return (T)((Object)((Builder)this.self()));
        }

        public T created(Date created) {
            this.created = created;
            return (T)((Object)((Builder)this.self()));
        }

        public T hostId(String hostId) {
            this.hostId = hostId;
            return (T)((Object)((Builder)this.self()));
        }

        public T accessIPv4(String accessIPv4) {
            this.accessIPv4 = accessIPv4;
            return (T)((Object)((Builder)this.self()));
        }

        public T accessIPv6(String accessIPv6) {
            this.accessIPv6 = accessIPv6;
            return (T)((Object)((Builder)this.self()));
        }

        public T status(Status status) {
            this.status = status;
            return (T)((Object)((Builder)this.self()));
        }

        public T image(Resource image) {
            this.image = image;
            return (T)((Object)((Builder)this.self()));
        }

        public T flavor(Resource flavor) {
            this.flavor = flavor;
            return (T)((Object)((Builder)this.self()));
        }

        public T keyName(String keyName) {
            this.keyName = keyName;
            return (T)((Object)((Builder)this.self()));
        }

        public T configDrive(String configDrive) {
            this.configDrive = configDrive;
            return (T)((Object)((Builder)this.self()));
        }

        public T addresses(Multimap<String, Address> addresses) {
            this.addresses = addresses;
            return (T)((Object)((Builder)this.self()));
        }

        public T metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return (T)((Object)((Builder)this.self()));
        }

        public T extendedStatus(ServerExtendedStatus extendedStatus) {
            this.extendedStatus = extendedStatus;
            return (T)((Object)((Builder)this.self()));
        }

        public T extraAttributes(ServerExtendedAttributes extendedAttributes) {
            this.extendedAttributes = extendedAttributes;
            return (T)((Object)((Builder)this.self()));
        }

        public T diskConfig(String diskConfig) {
            this.diskConfig = diskConfig;
            return (T)((Object)((Builder)this.self()));
        }

        public Server build() {
            return new Server(this);
        }

        public T fromServer(Server in) {
            return ((Builder)((Object)((Builder)((Object)((Builder)((Object)((Builder)((Object)((Builder)((Object)((Builder)((Object)((Builder)((Object)((Builder)((Object)((Builder)((Object)((Builder)((Object)((Builder)((Object)((Builder)((Object)((Builder)((Object)((Builder)((Object)((Builder)((Object)((Builder)((Object)((Builder)((Object)((Builder)super.fromResource((Resource)in)).uuid(in.getUuid()))).tenantId(in.getTenantId()))).userId(in.getUserId()))).updated(in.getUpdated()))).created(in.getCreated()))).hostId(in.getHostId()))).accessIPv4(in.getAccessIPv4()))).accessIPv6(in.getAccessIPv6()))).status(in.getStatus()))).image(in.getImage()))).flavor(in.getFlavor()))).keyName(in.getKeyName()))).configDrive(in.getConfigDrive()))).addresses(in.getAddresses()))).metadata(in.getMetadata()))).extendedStatus((ServerExtendedStatus)in.getExtendedStatus().orNull()))).extraAttributes((ServerExtendedAttributes)in.getExtendedAttributes().orNull()))).diskConfig((String)in.getDiskConfig().orNull());
        }
    }

    public static enum Status {
        ACTIVE(NodeState.RUNNING),
        BUILD(NodeState.PENDING),
        REBUILD(NodeState.PENDING),
        SUSPENDED(NodeState.SUSPENDED),
        RESIZE(NodeState.PENDING),
        VERIFY_RESIZE(NodeState.PENDING),
        REVERT_RESIZE(NodeState.PENDING),
        PASSWORD(NodeState.PENDING),
        REBOOT(NodeState.PENDING),
        HARD_REBOOT(NodeState.PENDING),
        DELETED(NodeState.TERMINATED),
        UNKNOWN(NodeState.UNRECOGNIZED),
        ERROR(NodeState.ERROR),
        UNRECOGNIZED(NodeState.UNRECOGNIZED),
        PAUSED(NodeState.SUSPENDED);

        protected final NodeState nodeState;

        private Status(NodeState nodeState) {
            this.nodeState = nodeState;
        }

        public String value() {
            return this.name();
        }

        public static Status fromValue(String v) {
            try {
                return Status.valueOf(v.replaceAll("\\(.*", ""));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }

        public NodeState getNodeState() {
            return this.nodeState;
        }
    }
}

