/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v1_1.domain;

import com.google.common.base.Objects;
import com.google.gson.annotations.SerializedName;

public class ServerExtendedAttributes {
    public static final String PREFIX = "OS-EXT-SRV-ATTR:";
    @SerializedName(value="OS-EXT-SRV-ATTR:instance_name")
    private String instanceName;
    @SerializedName(value="OS-EXT-SRV-ATTR:host")
    private String hostName;
    @SerializedName(value="OS-EXT-SRV-ATTR:hypervisor_hostname")
    private String hypervisorHostName;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromServerExtraAttributes(this);
    }

    protected ServerExtendedAttributes() {
    }

    protected ServerExtendedAttributes(Builder<?> builder) {
        this.instanceName = ((Builder)builder).instanceName;
        this.hostName = ((Builder)builder).hostName;
        this.hypervisorHostName = ((Builder)builder).hypervisorHostName;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getHypervisorHostName() {
        return this.hypervisorHostName;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.instanceName, this.hostName, this.hypervisorHostName});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ServerExtendedAttributes that = (ServerExtendedAttributes)ServerExtendedAttributes.class.cast(obj);
        return Objects.equal((Object)this.instanceName, (Object)that.instanceName) && Objects.equal((Object)this.hostName, (Object)that.hostName) && Objects.equal((Object)this.hypervisorHostName, (Object)that.hypervisorHostName);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((String)"").add("instanceName", (Object)this.instanceName).add("hostName", (Object)this.hostName).add("hypervisorHostName", (Object)this.hypervisorHostName);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        private String instanceName;
        private String hostName;
        private String hypervisorHostName;

        protected abstract T self();

        public T instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this.self();
        }

        public T hostName(String hostName) {
            this.hostName = hostName;
            return this.self();
        }

        public T hypervisorHostame(String hypervisorHostName) {
            this.hypervisorHostName = hypervisorHostName;
            return this.self();
        }

        public ServerExtendedAttributes build() {
            return new ServerExtendedAttributes(this);
        }

        public T fromServerExtraAttributes(ServerExtendedAttributes in) {
            return ((Builder)((Builder)this.instanceName(in.getInstanceName())).hostName(in.getHostName())).hypervisorHostame(in.getHypervisorHostName());
        }
    }
}

