/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v1_1.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.gson.annotations.SerializedName;
import java.util.Date;
import org.jclouds.javax.annotation.Nullable;

public class SimpleServerUsage {
    @SerializedName(value="name")
    private String instanceName;
    private double hours;
    @SerializedName(value="memory_mb")
    private double flavorMemoryMb;
    @SerializedName(value="local_gb")
    private double flavorLocalGb;
    @SerializedName(value="vcpus")
    private double flavorVcpus;
    @SerializedName(value="tenant_id")
    private String tenantId;
    @SerializedName(value="flavor")
    private String flavorName;
    @SerializedName(value="started_at")
    private Date instanceCreated;
    @SerializedName(value="ended_at")
    private Date instanceTerminiated;
    @SerializedName(value="state")
    private Status instanceStatus;
    private long uptime;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromSimpleServerUsage(this);
    }

    protected SimpleServerUsage() {
    }

    private SimpleServerUsage(Builder<?> builder) {
        this.instanceName = (String)Preconditions.checkNotNull((Object)((Builder)builder).instanceName, (Object)"instanceName");
        this.hours = ((Builder)builder).hours;
        this.flavorMemoryMb = ((Builder)builder).flavorMemoryMb;
        this.flavorLocalGb = ((Builder)builder).flavorLocalGb;
        this.flavorVcpus = ((Builder)builder).flavorVcpus;
        this.tenantId = (String)Preconditions.checkNotNull((Object)((Builder)builder).tenantId, (Object)"tenantId");
        this.flavorName = (String)Preconditions.checkNotNull((Object)((Builder)builder).flavorName, (Object)"flavorName");
        this.instanceCreated = ((Builder)builder).instanceCreated;
        this.instanceTerminiated = ((Builder)builder).instanceTerminiated;
        this.instanceStatus = (Status)((Object)Preconditions.checkNotNull((Object)((Object)((Builder)builder).instanceStatus), (Object)"instanceStatus"));
        this.uptime = (Long)Preconditions.checkNotNull((Object)((Builder)builder).uptime, (Object)"uptime");
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public double getFlavorMemoryMb() {
        return this.flavorMemoryMb;
    }

    public double getFlavorLocalGb() {
        return this.flavorLocalGb;
    }

    public double getFlavorVcpus() {
        return this.flavorVcpus;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getFlavorName() {
        return this.flavorName;
    }

    public Date getInstanceCreated() {
        return this.instanceCreated;
    }

    @Nullable
    public Date getInstanceTerminiated() {
        return this.instanceTerminiated;
    }

    public Status getInstanceStatus() {
        return this.instanceStatus;
    }

    public long getUptime() {
        return this.uptime;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.instanceName, this.flavorMemoryMb, this.flavorLocalGb, this.flavorVcpus, this.tenantId, this.flavorName, this.instanceCreated, this.instanceTerminiated, this.instanceStatus, this.uptime});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleServerUsage that = (SimpleServerUsage)SimpleServerUsage.class.cast(obj);
        return Objects.equal((Object)this.instanceName, (Object)that.instanceName) && Objects.equal((Object)this.flavorMemoryMb, (Object)that.flavorMemoryMb) && Objects.equal((Object)this.flavorLocalGb, (Object)that.flavorLocalGb) && Objects.equal((Object)this.flavorVcpus, (Object)that.flavorVcpus) && Objects.equal((Object)this.tenantId, (Object)that.tenantId) && Objects.equal((Object)this.flavorName, (Object)that.flavorName) && Objects.equal((Object)this.instanceCreated, (Object)that.instanceCreated) && Objects.equal((Object)this.instanceTerminiated, (Object)that.instanceTerminiated) && Objects.equal((Object)((Object)this.instanceStatus), (Object)((Object)that.instanceStatus)) && Objects.equal((Object)this.uptime, (Object)that.uptime);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((String)"").add("instanceName", (Object)this.instanceName).add("flavorMemoryMb", this.flavorMemoryMb).add("flavorLocalGb", this.flavorLocalGb).add("flavorVcpus", this.flavorVcpus).add("tenantId", (Object)this.tenantId).add("flavorName", (Object)this.flavorName).add("instanceCreated", (Object)this.instanceCreated).add("instanceTerminiated", (Object)this.instanceTerminiated).add("instanceStatus", (Object)this.instanceStatus).add("uptime", this.uptime);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        private String instanceName;
        private double hours;
        private double flavorMemoryMb;
        private double flavorLocalGb;
        private double flavorVcpus;
        private String tenantId;
        private String flavorName;
        private Date instanceCreated;
        private Date instanceTerminiated;
        private Status instanceStatus;
        private long uptime;

        protected abstract T self();

        public T instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this.self();
        }

        public T hours(double hours) {
            this.hours = hours;
            return this.self();
        }

        public T flavorMemoryMb(double flavorMemoryMb) {
            this.flavorMemoryMb = flavorMemoryMb;
            return this.self();
        }

        public T flavorLocalGb(double flavorLocalGb) {
            this.flavorLocalGb = flavorLocalGb;
            return this.self();
        }

        public T flavorVcpus(double flavorVcpus) {
            this.flavorVcpus = flavorVcpus;
            return this.self();
        }

        public T tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this.self();
        }

        public T flavorName(String flavorName) {
            this.flavorName = flavorName;
            return this.self();
        }

        public T instanceCreated(Date instanceCreated) {
            this.instanceCreated = instanceCreated;
            return this.self();
        }

        public T instanceTerminiated(Date instanceTerminiated) {
            this.instanceTerminiated = instanceTerminiated;
            return this.self();
        }

        public T instanceStatus(Status instanceStatus) {
            this.instanceStatus = instanceStatus;
            return this.self();
        }

        public T uptime(long uptime) {
            this.uptime = uptime;
            return this.self();
        }

        public SimpleServerUsage build() {
            return new SimpleServerUsage(this);
        }

        public T fromSimpleServerUsage(SimpleServerUsage in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.instanceName(in.getInstanceName())).flavorMemoryMb(in.getFlavorMemoryMb())).flavorLocalGb(in.getFlavorLocalGb())).flavorVcpus(in.getFlavorVcpus())).tenantId(in.getTenantId())).flavorName(in.getFlavorName())).instanceCreated(in.getInstanceCreated())).instanceTerminiated(in.getInstanceTerminiated())).instanceStatus(in.getInstanceStatus())).uptime(in.getUptime());
        }
    }

    public static enum Status {
        UNRECOGNIZED,
        ACTIVE;


        public String value() {
            return this.name();
        }

        public static Status fromValue(String v) {
            try {
                return Status.valueOf(v.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

