/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v1_1.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.gson.annotations.SerializedName;

public class VirtualInterface {
    private String id;
    @SerializedName(value="mac_address")
    private String macAddress;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromVirtualInterface(this);
    }

    protected VirtualInterface() {
    }

    protected VirtualInterface(Builder<?> builder) {
        this.id = (String)Preconditions.checkNotNull((Object)((Builder)builder).id, (Object)"id");
        this.macAddress = (String)Preconditions.checkNotNull((Object)((Builder)builder).macAddress, (Object)"macAddress");
    }

    public String getId() {
        return this.id;
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.macAddress});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        VirtualInterface that = (VirtualInterface)VirtualInterface.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.macAddress, (Object)that.macAddress);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((String)"").add("id", (Object)this.id).add("macAddress", (Object)this.macAddress);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        private String id;
        private String macAddress;

        protected abstract T self();

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T macAddress(String macAddress) {
            this.macAddress = macAddress;
            return this.self();
        }

        public VirtualInterface build() {
            return new VirtualInterface(this);
        }

        public T fromVirtualInterface(VirtualInterface in) {
            return ((Builder)this.id(in.getId())).macAddress(in.getMacAddress());
        }
    }
}

