/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v1_1.domain;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.gson.annotations.SerializedName;
import java.util.Collections;
import java.util.Date;
import java.util.Map;

public class VolumeType {
    private String id;
    private String name;
    @SerializedName(value="created_at")
    private Date created;
    @SerializedName(value="updated_at")
    private Optional<Date> updated = Optional.absent();
    @SerializedName(value="extra_specs")
    private Map<String, String> extraSpecs = ImmutableMap.of();

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromVolumeType(this);
    }

    protected VolumeType() {
    }

    protected VolumeType(Builder<?> builder) {
        this.id = (String)Preconditions.checkNotNull((Object)((Builder)builder).id, (Object)"id");
        this.name = (String)Preconditions.checkNotNull((Object)((Builder)builder).name, (Object)"name");
        this.extraSpecs = (Map)Preconditions.checkNotNull((Object)((Builder)builder).extraSpecs, (Object)"extraSpecs");
        this.created = (Date)Preconditions.checkNotNull((Object)((Builder)builder).created, (Object)"created");
        this.updated = Optional.fromNullable((Object)((Builder)builder).updated);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Date getCreated() {
        return this.created;
    }

    public Optional<Date> getUpdated() {
        return this.updated;
    }

    public Map<String, String> getExtraSpecs() {
        return Collections.unmodifiableMap(this.extraSpecs);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.name, this.created, this.updated, this.extraSpecs});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        VolumeType that = (VolumeType)VolumeType.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.created, (Object)that.created) && Objects.equal(this.updated, that.updated) && Objects.equal(this.extraSpecs, that.extraSpecs);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((String)"").add("id", (Object)this.id).add("name", (Object)this.name).add("created", (Object)this.created).add("updated", this.updated).add("extraSpecs", this.extraSpecs);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        private String id;
        private String name;
        private Date created = new Date();
        private Date updated;
        private Map<String, String> extraSpecs;

        protected abstract T self();

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T created(Date created) {
            this.created = created;
            return this.self();
        }

        public T updated(Date updated) {
            this.updated = updated;
            return this.self();
        }

        public T extraSpecs(Map<String, String> extraSpecs) {
            this.extraSpecs = ImmutableMap.copyOf(extraSpecs);
            return this.self();
        }

        public VolumeType build() {
            return new VolumeType(this);
        }

        public T fromVolumeType(VolumeType in) {
            return ((Builder)((Builder)((Builder)((Builder)this.id(in.getId())).name(in.getName())).extraSpecs(in.getExtraSpecs())).created(in.getCreated())).updated((Date)in.getUpdated().orNull());
        }
    }
}

