/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v1_1.extensions;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.concurrent.Timeout;
import org.jclouds.openstack.filters.AuthenticateRequest;
import org.jclouds.openstack.services.Extension;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.Unwrap;
import org.jclouds.rest.binders.BindToJsonPayload;
import org.jclouds.rest.functions.ReturnEmptyMapOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnFalseOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;

@Extension(of="compute", namespace="http://docs.openstack.org/ext/flavor_extra_specs/api/v1.1")
@Timeout(duration=180L, timeUnit=TimeUnit.SECONDS)
@RequestFilters(value={AuthenticateRequest.class})
@Consumes(value={"application/json"})
public interface FlavorExtraSpecsAsyncClient {
    @GET
    @SelectJson(value="extra_specs")
    @Path(value="/flavors/{flavor_id}/os-extra_specs")
    @ExceptionParser(value=ReturnEmptyMapOnNotFoundOr404.class)
    public ListenableFuture<Map<String, String>> getAllExtraSpecs(@PathParam(value="flavor_id") String var1);

    @POST
    @Path(value="/flavors/{flavor_id}/os-extra_specs")
    @Produces(value={"application/json"})
    @ExceptionParser(value=ReturnFalseOnNotFoundOr404.class)
    @MapBinder(value=BindToJsonPayload.class)
    public ListenableFuture<Boolean> setAllExtraSpecs(@PathParam(value="flavor_id") String var1, @PayloadParam(value="extra_specs") Map<String, String> var2);

    @GET
    @Path(value="/flavors/{flavor_id}/os-extra_specs/{key}")
    @Unwrap
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<String> getExtraSpec(@PathParam(value="flavor_id") String var1, @PathParam(value="key") String var2);

    @PUT
    @Path(value="/flavors/{flavor_id}/os-extra_specs/{key}")
    @Produces(value={"application/json"})
    @ExceptionParser(value=ReturnFalseOnNotFoundOr404.class)
    @Payload(value="%7B\"{key}\":\"{value}\"%7D")
    public ListenableFuture<Boolean> setExtraSpec(@PathParam(value="flavor_id") String var1, @PathParam(value="key") @PayloadParam(value="key") String var2, @PayloadParam(value="value") String var3);

    @DELETE
    @Path(value="/flavors/{flavor_id}/os-extra_specs/{key}")
    @ExceptionParser(value=ReturnFalseOnNotFoundOr404.class)
    public ListenableFuture<Boolean> deleteExtraSpec(@PathParam(value="flavor_id") String var1, @PathParam(value="key") String var2);
}

