/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v1_1.extensions;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.concurrent.Timeout;
import org.jclouds.openstack.filters.AuthenticateRequest;
import org.jclouds.openstack.nova.v1_1.domain.Quotas;
import org.jclouds.openstack.services.Extension;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.binders.BindToJsonPayload;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;

@Extension(of="compute", namespace="http://docs.openstack.org/ext/quotas-sets/api/v1.1")
@Timeout(duration=180L, timeUnit=TimeUnit.SECONDS)
@RequestFilters(value={AuthenticateRequest.class})
@Path(value="/os-quota-sets")
public interface QuotaAsyncClient {
    @GET
    @SelectJson(value="quota_set")
    @Consumes(value={"application/json"})
    @Path(value="/{tenant_id}")
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<Quotas> getQuotasForTenant(@PathParam(value="tenant_id") String var1);

    @PUT
    @Path(value="/{tenant_id}")
    @Produces(value={"application/json"})
    @MapBinder(value=BindToJsonPayload.class)
    public ListenableFuture<Boolean> updateQuotasForTenant(@PathParam(value="tenant_id") String var1, @PayloadParam(value="quota_set") Quotas var2);

    @GET
    @SelectJson(value="quota_set")
    @Consumes(value={"application/json"})
    @Path(value="/{tenant_id}/defaults")
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<Quotas> getDefaultQuotasForTenant(@PathParam(value="tenant_id") String var1);
}

