/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v1_1.extensions;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.openstack.filters.AuthenticateRequest;
import org.jclouds.openstack.nova.v1_1.domain.Volume;
import org.jclouds.openstack.nova.v1_1.domain.VolumeAttachment;
import org.jclouds.openstack.nova.v1_1.domain.VolumeSnapshot;
import org.jclouds.openstack.nova.v1_1.options.CreateVolumeOptions;
import org.jclouds.openstack.nova.v1_1.options.CreateVolumeSnapshotOptions;
import org.jclouds.openstack.services.Extension;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.annotations.WrapWith;
import org.jclouds.rest.functions.ReturnEmptySetOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnFalseOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;

@Extension(of="compute", namespace="http://docs.openstack.org/ext/volumes/api/v1.1")
@SkipEncoding(value={47, 61})
@RequestFilters(value={AuthenticateRequest.class})
public interface VolumeAsyncClient {
    @GET
    @Path(value="/os-volumes")
    @SelectJson(value="volumes")
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<Set<Volume>> listVolumes();

    @GET
    @Path(value="/os-volumes/detail")
    @SelectJson(value="volumes")
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<Set<Volume>> listVolumesInDetail();

    @GET
    @Path(value="/os-volumes/{id}")
    @SelectJson(value="volume")
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<Volume> getVolume(@PathParam(value="id") String var1);

    @POST
    @Path(value="/os-volumes")
    @SelectJson(value="volume")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @MapBinder(value=CreateVolumeOptions.class)
    public ListenableFuture<Volume> createVolume(@PayloadParam(value="size") int var1, CreateVolumeOptions ... var2);

    @DELETE
    @Path(value="/os-volumes/{id}")
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnFalseOnNotFoundOr404.class)
    public ListenableFuture<Boolean> deleteVolume(@PathParam(value="id") String var1);

    @GET
    @Path(value="/servers/{server_id}/os-volume_attachments")
    @SelectJson(value="volumeAttachments")
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<Set<VolumeAttachment>> listAttachmentsOnServer(@PathParam(value="server_id") String var1);

    @GET
    @Path(value="/servers/{server_id}/os-volume_attachments/{id}")
    @SelectJson(value="volumeAttachment")
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<VolumeAttachment> getAttachmentForVolumeOnServer(@PathParam(value="id") String var1, @PathParam(value="server_id") String var2);

    @POST
    @Path(value="/servers/{server_id}/os-volume_attachments")
    @SelectJson(value="volumeAttachment")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @WrapWith(value="volumeAttachment")
    public ListenableFuture<VolumeAttachment> attachVolumeToServerAsDevice(@PayloadParam(value="volumeId") String var1, @PathParam(value="server_id") String var2, @PayloadParam(value="device") String var3);

    @DELETE
    @Path(value="/servers/{server_id}/os-volume_attachments/{id}")
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnFalseOnNotFoundOr404.class)
    public ListenableFuture<Boolean> detachVolumeFromServer(@PathParam(value="id") String var1, @PathParam(value="server_id") String var2);

    @GET
    @Path(value="/os-snapshots")
    @SelectJson(value="snapshots")
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<Set<VolumeSnapshot>> listSnapshots();

    @GET
    @Path(value="/os-snapshots/detail")
    @SelectJson(value="snapshots")
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<Set<VolumeSnapshot>> listSnapshotsInDetail();

    @GET
    @Path(value="/os-snapshots/{id}")
    @SelectJson(value="snapshot")
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<VolumeSnapshot> getSnapshot(@PathParam(value="id") String var1);

    @POST
    @Path(value="/os-snapshots")
    @SelectJson(value="snapshot")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @MapBinder(value=CreateVolumeSnapshotOptions.class)
    public ListenableFuture<VolumeSnapshot> createSnapshot(@PayloadParam(value="volume_id") String var1, CreateVolumeSnapshotOptions ... var2);

    @DELETE
    @Path(value="/os-snapshots/{id}")
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnFalseOnNotFoundOr404.class)
    public ListenableFuture<Boolean> deleteSnapshot(@PathParam(value="id") String var1);
}

