/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v1_1.functions;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseFirstJsonValueNamed;
import org.jclouds.json.internal.GsonWrapper;

public class FieldValueResponseParsers {

    public static abstract class FieldValueResponseParser<T>
    implements Function<HttpResponse, Boolean> {
        private final T expectedValue;
        private final ParseFirstJsonValueNamed<T> valueParser;

        public FieldValueResponseParser(GsonWrapper wrapper, String fieldName, T expectedValue) {
            this.valueParser = new ParseFirstJsonValueNamed(wrapper, new TypeLiteral<T>(){}, fieldName);
            this.expectedValue = expectedValue;
        }

        public Boolean apply(HttpResponse response) {
            return Objects.equal(this.expectedValue, (Object)this.valueParser.apply(response));
        }
    }

    @Singleton
    public static class PowerIsRebootResponseParser
    extends FieldValueResponseParser<String> {
        @Inject
        public PowerIsRebootResponseParser(GsonWrapper wrapper) {
            super(wrapper, "power_action", "reboot");
        }
    }

    @Singleton
    public static class PowerIsShutdownResponseParser
    extends FieldValueResponseParser<String> {
        @Inject
        public PowerIsShutdownResponseParser(GsonWrapper wrapper) {
            super(wrapper, "power_action", "shutdown");
        }
    }

    @Singleton
    public static class PowerIsStartupResponseParser
    extends FieldValueResponseParser<String> {
        @Inject
        public PowerIsStartupResponseParser(GsonWrapper wrapper) {
            super(wrapper, "power_action", "startup");
        }
    }

    @Singleton
    public static class MaintenanceModeDisabledResponseParser
    extends FieldValueResponseParser<String> {
        @Inject
        public MaintenanceModeDisabledResponseParser(GsonWrapper wrapper) {
            super(wrapper, "maintenance_mode", "off_maintenance");
        }
    }

    @Singleton
    public static class MaintenanceModeEnabledResponseParser
    extends FieldValueResponseParser<String> {
        @Inject
        public MaintenanceModeEnabledResponseParser(GsonWrapper wrapper) {
            super(wrapper, "maintenance_mode", "on_maintenance");
        }
    }

    @Singleton
    public static class StatusDisabledResponseParser
    extends FieldValueResponseParser<String> {
        @Inject
        public StatusDisabledResponseParser(GsonWrapper wrapper) {
            super(wrapper, "status", "disabled");
        }
    }

    @Singleton
    public static class StatusEnabledResponseParser
    extends FieldValueResponseParser<String> {
        @Inject
        public StatusEnabledResponseParser(GsonWrapper wrapper) {
            super(wrapper, "status", "enabled");
        }
    }
}

