/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.domain;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.gson.annotations.SerializedName;
import org.jclouds.openstack.v2_0.domain.Resource;

public class Flavor
extends Resource {
    private int ram;
    private int disk;
    private int vcpus;
    private Optional<String> swap = Optional.absent();
    @SerializedName(value="rxtx_factor")
    private Optional<Double> rxtxFactor = Optional.absent();
    @SerializedName(value="OS-FLV-EXT-DATA:ephemeral")
    private Optional<Integer> ephemeral = Optional.absent();

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromFlavor(this);
    }

    protected Flavor() {
    }

    protected Flavor(Builder<?> builder) {
        super(builder);
        this.ram = ((Builder)builder).ram;
        this.disk = ((Builder)builder).disk;
        this.vcpus = ((Builder)builder).vcpus;
        this.swap = Optional.fromNullable((Object)((Builder)builder).swap);
        this.rxtxFactor = Optional.fromNullable((Object)((Builder)builder).rxtxFactor);
        this.ephemeral = Optional.fromNullable((Object)((Builder)builder).ephemeral);
    }

    public int getRam() {
        return this.ram;
    }

    public int getDisk() {
        return this.disk;
    }

    public int getVcpus() {
        return this.vcpus;
    }

    public Optional<String> getSwap() {
        return this.swap;
    }

    public Optional<Double> getRxtxFactor() {
        return this.rxtxFactor;
    }

    public Optional<Integer> getEphemeral() {
        return this.ephemeral;
    }

    protected Objects.ToStringHelper string() {
        return super.string().add("ram", this.ram).add("disk", this.disk).add("vcpus", this.vcpus).add("swap", this.swap).add("rxtxFactor", this.rxtxFactor).add("ephemeral", this.ephemeral);
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>>
    extends Resource.Builder<T> {
        private int ram;
        private int disk;
        private int vcpus;
        private String swap;
        private Double rxtxFactor;
        private Integer ephemeral;

        public T ram(int ram) {
            this.ram = ram;
            return (T)((Object)((Builder)this.self()));
        }

        public T disk(int disk) {
            this.disk = disk;
            return (T)((Object)((Builder)this.self()));
        }

        public T vcpus(int vcpus) {
            this.vcpus = vcpus;
            return (T)((Object)((Builder)this.self()));
        }

        public T swap(String swap) {
            this.swap = swap;
            return (T)((Object)((Builder)this.self()));
        }

        public T rxtxFactor(Double rxtxFactor) {
            this.rxtxFactor = rxtxFactor;
            return (T)((Object)((Builder)this.self()));
        }

        public T ephemeral(Integer ephemeral) {
            this.ephemeral = ephemeral;
            return (T)((Object)((Builder)this.self()));
        }

        public Flavor build() {
            return new Flavor(this);
        }

        public T fromFlavor(Flavor in) {
            return ((Builder)((Object)((Builder)((Object)((Builder)((Object)((Builder)((Object)((Builder)((Object)((Builder)super.fromResource((Resource)in)).ram(in.getRam()))).disk(in.getDisk()))).vcpus(in.getVcpus()))).swap((String)in.getSwap().orNull()))).rxtxFactor((Double)in.getRxtxFactor().orNull()))).ephemeral((Integer)in.getEphemeral().orNull());
        }
    }
}

