/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.gson.annotations.SerializedName;
import org.jclouds.javax.annotation.Nullable;

public class HostResourceUsage {
    private String host;
    private String project;
    @SerializedName(value="memory_mb")
    private int memoryMb;
    private int cpu;
    @SerializedName(value="disk_gb")
    private int diskGb;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromHostResourceUsage(this);
    }

    protected HostResourceUsage() {
    }

    protected HostResourceUsage(Builder<?> builder) {
        this.host = (String)Preconditions.checkNotNull((Object)((Builder)builder).host, (Object)"host");
        this.project = ((Builder)builder).project;
        this.memoryMb = (Integer)Preconditions.checkNotNull((Object)((Builder)builder).memoryMb, (Object)"memoryMb");
        this.cpu = (Integer)Preconditions.checkNotNull((Object)((Builder)builder).cpu, (Object)"cpu");
        this.diskGb = (Integer)Preconditions.checkNotNull((Object)((Builder)builder).diskGb, (Object)"diskGb");
    }

    public String getHost() {
        return this.host;
    }

    @Nullable
    public String getProject() {
        return this.project;
    }

    public int getMemoryMb() {
        return this.memoryMb;
    }

    public int getCpu() {
        return this.cpu;
    }

    public int getDiskGb() {
        return this.diskGb;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.host, this.project, this.memoryMb, this.cpu, this.diskGb});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HostResourceUsage that = (HostResourceUsage)HostResourceUsage.class.cast(obj);
        return Objects.equal((Object)this.host, (Object)that.host) && Objects.equal((Object)this.project, (Object)that.project) && Objects.equal((Object)this.memoryMb, (Object)that.memoryMb) && Objects.equal((Object)this.cpu, (Object)that.cpu) && Objects.equal((Object)this.diskGb, (Object)that.diskGb);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((String)"").add("host", (Object)this.host).add("project", (Object)this.project).add("memoryMb", this.memoryMb).add("cpu", this.cpu).add("diskGb", this.diskGb);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        private String host;
        private String project;
        private int memoryMb;
        private int cpu;
        private int diskGb;

        protected abstract T self();

        public T host(String host) {
            this.host = host;
            return this.self();
        }

        public T project(String project) {
            this.project = project;
            return this.self();
        }

        public T memoryMb(int memoryMb) {
            this.memoryMb = memoryMb;
            return this.self();
        }

        public T cpu(int cpu) {
            this.cpu = cpu;
            return this.self();
        }

        public T diskGb(int diskGb) {
            this.diskGb = diskGb;
            return this.self();
        }

        public HostResourceUsage build() {
            return new HostResourceUsage(this);
        }

        public T fromHostResourceUsage(HostResourceUsage in) {
            return ((Builder)((Builder)((Builder)((Builder)this.host(in.getHost())).project(in.getProject())).memoryMb(in.getMemoryMb())).cpu(in.getCpu())).diskGb(in.getDiskGb());
        }
    }
}

