/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.domain;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.gson.annotations.SerializedName;
import org.jclouds.openstack.nova.v2_0.domain.IpProtocol;

@Beta
public class Ingress {
    @SerializedName(value="ip_protocol")
    protected IpProtocol ipProtocol;
    @SerializedName(value="from_port")
    protected int fromPort;
    @SerializedName(value="to_port")
    protected int toPort;

    public static Builder builder() {
        return new Builder();
    }

    protected Ingress() {
    }

    protected Ingress(IpProtocol ipProtocol, int fromPort, int toPort) {
        this.fromPort = fromPort;
        this.toPort = toPort;
        this.ipProtocol = (IpProtocol)((Object)Preconditions.checkNotNull((Object)((Object)ipProtocol), (Object)"ipProtocol"));
    }

    public IpProtocol getIpProtocol() {
        return this.ipProtocol;
    }

    public int getFromPort() {
        return this.fromPort;
    }

    public int getToPort() {
        return this.toPort;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Ingress)) {
            return false;
        }
        Ingress that = (Ingress)Ingress.class.cast(o);
        return Objects.equal((Object)((Object)this.ipProtocol), (Object)((Object)that.ipProtocol)) && Objects.equal((Object)this.fromPort, (Object)that.fromPort) && Objects.equal((Object)this.toPort, (Object)that.toPort);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.ipProtocol, this.fromPort, this.toPort});
    }

    public String toString() {
        return this.string().toString();
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((String)"").add("ipProtocol", (Object)this.ipProtocol).add("fromPort", this.fromPort).add("toPort", this.toPort);
    }

    public static class Builder {
        protected IpProtocol ipProtocol;
        protected int fromPort;
        protected int toPort;

        public Builder ipProtocol(IpProtocol ipProtocol) {
            this.ipProtocol = ipProtocol;
            return this;
        }

        public Builder fromPort(int fromPort) {
            this.fromPort = fromPort;
            return this;
        }

        public Builder toPort(int toPort) {
            this.toPort = toPort;
            return this;
        }

        public Ingress build() {
            return new Ingress(this.ipProtocol, this.fromPort, this.toPort);
        }
    }
}

