/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import java.net.URI;
import java.util.Properties;
import java.util.Set;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.openstack.keystone.v2_0.config.KeystoneAuthenticationModule;
import org.jclouds.openstack.nova.v2_0.NovaAsyncClient;
import org.jclouds.openstack.nova.v2_0.NovaClient;
import org.jclouds.openstack.nova.v2_0.compute.config.NovaComputeServiceContextModule;
import org.jclouds.openstack.nova.v2_0.config.NovaRestClientModule;
import org.jclouds.rest.RestContext;
import org.jclouds.rest.internal.BaseRestApiMetadata;

public class NovaApiMetadata
extends BaseRestApiMetadata {
    private static final long serialVersionUID = 6725672099385580694L;
    public static final TypeToken<RestContext<NovaClient, NovaAsyncClient>> CONTEXT_TOKEN = new TypeToken<RestContext<NovaClient, NovaAsyncClient>>(){
        private static final long serialVersionUID = -5070937833892503232L;
    };

    public Builder toBuilder() {
        return new Builder().fromApiMetadata((ApiMetadata)this);
    }

    public NovaApiMetadata() {
        this(new Builder());
    }

    protected NovaApiMetadata(Builder builder) {
        super((BaseRestApiMetadata.Builder)builder);
    }

    public static Properties defaultProperties() {
        Properties properties = BaseRestApiMetadata.defaultProperties();
        properties.setProperty("jclouds.ssh.max-retries", "7");
        properties.setProperty("jclouds.ssh.retry-auth", "true");
        properties.setProperty("jclouds.keystone.service-type", "compute");
        properties.setProperty("jclouds.keystone.credential-type", "passwordCredentials");
        properties.setProperty("jclouds.keystone.version", "2.0");
        properties.setProperty("jclouds.openstack-nova.auto-allocate-floating-ips", "false");
        properties.setProperty("jclouds.openstack-nova.auto-generate-keypairs", "false");
        properties.setProperty("jclouds.openstack-nova.timeout.securitygroup-present", "500");
        return properties;
    }

    public static class Builder
    extends BaseRestApiMetadata.Builder {
        protected Builder() {
            super(NovaClient.class, NovaAsyncClient.class);
            this.id("openstack-nova").name("OpenStack Nova Diablo+ API").identityName("tenantName:user or user").credentialName("password").documentation(URI.create("http://api.openstack.org/")).version("1.1").defaultEndpoint("http://localhost:5000").defaultProperties(NovaApiMetadata.defaultProperties()).view(TypeToken.of(ComputeServiceContext.class)).defaultModules((Set)ImmutableSet.of(KeystoneAuthenticationModule.KeystoneAuthenticationModuleForZones.class, NovaRestClientModule.class, NovaComputeServiceContextModule.class));
        }

        public NovaApiMetadata build() {
            return new NovaApiMetadata(this);
        }

        public Builder fromApiMetadata(ApiMetadata in) {
            super.fromApiMetadata(in);
            return this;
        }
    }
}

