/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.binders;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.json.Json;
import org.jclouds.openstack.nova.v2_0.domain.Ingress;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.binders.BindToJsonPayload;
import org.jclouds.rest.internal.GeneratedHttpRequest;

@Singleton
public class BindSecurityGroupRuleToJsonPayload
extends BindToJsonPayload
implements MapBinder {
    @Inject
    public BindSecurityGroupRuleToJsonPayload(Json jsonBinder) {
        super(jsonBinder);
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object toBind) {
        throw new IllegalStateException("BindCredentialsToJsonPayload needs parameters");
    }

    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        ImmutableMap.Builder payload = ImmutableMap.builder();
        payload.putAll(postParams);
        Preconditions.checkArgument((boolean)(Preconditions.checkNotNull(request, (Object)"request") instanceof GeneratedHttpRequest), (Object)"this binder is only valid for GeneratedHttpRequests!");
        GeneratedHttpRequest gRequest = (GeneratedHttpRequest)request;
        Ingress ingress = (Ingress)Ingress.class.cast(Iterables.find((Iterable)gRequest.getArgs(), (Predicate)Predicates.instanceOf(Ingress.class)));
        payload.put((Object)"ip_protocol", (Object)ingress.getIpProtocol().toString());
        payload.put((Object)"from_port", (Object)(ingress.getFromPort() + ""));
        payload.put((Object)"to_port", (Object)(ingress.getToPort() + ""));
        return (R)super.bindToRequest(request, (Object)ImmutableMap.of((Object)"security_group_rule", (Object)payload.build()));
    }
}

