/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute.strategy;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Multimap;
import com.google.common.primitives.Ints;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.config.CustomizationResponse;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.compute.strategy.CreateNodeWithGroupEncodedIntoName;
import org.jclouds.compute.strategy.CustomizeNodeAndAddToGoodMapOrPutExceptionIntoBadMap;
import org.jclouds.compute.strategy.ListNodesStrategy;
import org.jclouds.compute.strategy.impl.CreateNodesWithGroupEncodedIntoNameThenAddToSet;
import org.jclouds.concurrent.Futures;
import org.jclouds.crypto.SshKeys;
import org.jclouds.openstack.nova.v2_0.NovaClient;
import org.jclouds.openstack.nova.v2_0.compute.functions.AllocateAndAddFloatingIpToNode;
import org.jclouds.openstack.nova.v2_0.compute.options.NovaTemplateOptions;
import org.jclouds.openstack.nova.v2_0.domain.KeyPair;
import org.jclouds.openstack.nova.v2_0.domain.zonescoped.SecurityGroupInZone;
import org.jclouds.openstack.nova.v2_0.domain.zonescoped.ZoneAndName;
import org.jclouds.openstack.nova.v2_0.domain.zonescoped.ZoneSecurityGroupNameAndPorts;

@Singleton
public class ApplyNovaTemplateOptionsCreateNodesWithGroupEncodedIntoNameThenAddToSet
extends CreateNodesWithGroupEncodedIntoNameThenAddToSet {
    private final AllocateAndAddFloatingIpToNode allocateAndAddFloatingIpToNode;
    private final LoadingCache<ZoneAndName, SecurityGroupInZone> securityGroupCache;
    private final LoadingCache<ZoneAndName, KeyPair> keyPairCache;
    private final NovaClient novaClient;

    @Inject
    protected ApplyNovaTemplateOptionsCreateNodesWithGroupEncodedIntoNameThenAddToSet(CreateNodeWithGroupEncodedIntoName addNodeWithTagStrategy, ListNodesStrategy listNodesStrategy, GroupNamingConvention.Factory namingConvention, CustomizeNodeAndAddToGoodMapOrPutExceptionIntoBadMap.Factory customizeNodeAndAddToGoodMapOrPutExceptionIntoBadMapFactory, @Named(value="jclouds.user-threads") ExecutorService executor, AllocateAndAddFloatingIpToNode allocateAndAddFloatingIpToNode, LoadingCache<ZoneAndName, SecurityGroupInZone> securityGroupCache, LoadingCache<ZoneAndName, KeyPair> keyPairCache, NovaClient novaClient) {
        super(addNodeWithTagStrategy, listNodesStrategy, namingConvention, executor, customizeNodeAndAddToGoodMapOrPutExceptionIntoBadMapFactory);
        this.securityGroupCache = (LoadingCache)Preconditions.checkNotNull(securityGroupCache, (Object)"securityGroupCache");
        this.keyPairCache = (LoadingCache)Preconditions.checkNotNull(keyPairCache, (Object)"keyPairCache");
        this.allocateAndAddFloatingIpToNode = (AllocateAndAddFloatingIpToNode)Preconditions.checkNotNull((Object)allocateAndAddFloatingIpToNode, (Object)"allocateAndAddFloatingIpToNode");
        this.novaClient = (NovaClient)Preconditions.checkNotNull((Object)novaClient, (Object)"novaClient");
    }

    public Map<?, Future<Void>> execute(String group, int count, Template template, Set<NodeMetadata> goodNodes, Map<NodeMetadata, Exception> badNodes, Multimap<NodeMetadata, CustomizationResponse> customizationResponses) {
        Template mutableTemplate = template.clone();
        NovaTemplateOptions templateOptions = (NovaTemplateOptions)NovaTemplateOptions.class.cast(mutableTemplate.getOptions());
        assert (template.getOptions().equals((Object)templateOptions)) : "options didn't clone properly";
        String zone = mutableTemplate.getLocation().getId();
        if (templateOptions.shouldAutoAssignFloatingIp()) {
            Preconditions.checkArgument((boolean)this.novaClient.getFloatingIPExtensionForZone(zone).isPresent(), (String)"Floating IPs are required by options, but the extension is not available! options: %s", (Object[])new Object[]{templateOptions});
        }
        boolean keyPairExensionPresent = this.novaClient.getKeyPairExtensionForZone(zone).isPresent();
        if (templateOptions.shouldGenerateKeyPair()) {
            Preconditions.checkArgument((boolean)keyPairExensionPresent, (String)"Key Pairs are required by options, but the extension is not available! options: %s", (Object[])new Object[]{templateOptions});
            KeyPair keyPair = (KeyPair)this.keyPairCache.getUnchecked((Object)ZoneAndName.fromZoneAndName(zone, this.namingConvention.create().sharedNameForGroup(group)));
            this.keyPairCache.asMap().put(ZoneAndName.fromZoneAndName(zone, keyPair.getName()), keyPair);
            templateOptions.keyPairName(keyPair.getName());
        } else if (templateOptions.getKeyPairName() != null) {
            Preconditions.checkArgument((boolean)keyPairExensionPresent, (String)"Key Pairs are required by options, but the extension is not available! options: %s", (Object[])new Object[]{templateOptions});
            if (templateOptions.getLoginPrivateKey() != null) {
                String pem = templateOptions.getLoginPrivateKey();
                KeyPair keyPair = KeyPair.builder().name(templateOptions.getKeyPairName()).fingerprint(SshKeys.fingerprintPrivateKey((String)pem)).privateKey(pem).build();
                this.keyPairCache.asMap().put(ZoneAndName.fromZoneAndName(zone, keyPair.getName()), keyPair);
            }
        }
        boolean securityGroupExensionPresent = this.novaClient.getSecurityGroupExtensionForZone(zone).isPresent();
        List inboundPorts = Ints.asList((int[])templateOptions.getInboundPorts());
        if (templateOptions.getSecurityGroupNames().size() > 0) {
            Preconditions.checkArgument((boolean)this.novaClient.getSecurityGroupExtensionForZone(zone).isPresent(), (String)"Security groups are required by options, but the extension is not available! options: %s", (Object[])new Object[]{templateOptions});
        } else if (securityGroupExensionPresent && inboundPorts.size() > 0) {
            String securityGroupName = this.namingConvention.create().sharedNameForGroup(group);
            try {
                this.securityGroupCache.get((Object)new ZoneSecurityGroupNameAndPorts(zone, securityGroupName, inboundPorts));
            }
            catch (ExecutionException e) {
                throw Throwables.propagate((Throwable)e.getCause());
            }
            templateOptions.securityGroupNames(securityGroupName);
        }
        return super.execute(group, count, mutableTemplate, goodNodes, badNodes, customizationResponses);
    }

    protected Future<AtomicReference<NodeMetadata>> createNodeInGroupWithNameAndTemplate(String group, String name, Template template) {
        Future future = super.createNodeInGroupWithNameAndTemplate(group, name, template);
        NovaTemplateOptions templateOptions = (NovaTemplateOptions)NovaTemplateOptions.class.cast(template.getOptions());
        if (templateOptions.shouldAutoAssignFloatingIp()) {
            return Futures.compose((Future)future, (Function)this.allocateAndAddFloatingIpToNode, (ExecutorService)this.executor);
        }
        return future;
    }
}

