/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.gson.annotations.SerializedName;
import java.util.Set;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.nova.v2_0.domain.SecurityGroupRule;

public class SecurityGroup {
    protected String id;
    @SerializedName(value="tenant_id")
    protected String tenantId;
    protected String name;
    protected String description;
    protected Set<SecurityGroupRule> rules = ImmutableSet.of();

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return SecurityGroup.builder().fromSecurityGroup(this);
    }

    protected SecurityGroup() {
    }

    protected SecurityGroup(String id, String tenantId, @Nullable String name, @Nullable String description, Set<SecurityGroupRule> rules) {
        this.id = id;
        this.tenantId = tenantId;
        this.name = name;
        this.description = description;
        this.rules = ((Set)Preconditions.checkNotNull(rules, (Object)"rules")).size() == 0 ? null : ImmutableSet.copyOf(rules);
    }

    public String getId() {
        return this.id;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Set<SecurityGroupRule> getRules() {
        return this.rules == null ? ImmutableSet.of() : this.rules;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof SecurityGroup) {
            SecurityGroup other = (SecurityGroup)SecurityGroup.class.cast(object);
            return Objects.equal((Object)this.tenantId, (Object)other.tenantId) && Objects.equal((Object)this.id, (Object)other.id) && Objects.equal((Object)this.name, (Object)other.name);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.tenantId, this.id, this.name});
    }

    public String toString() {
        return Objects.toStringHelper((String)"").add("tenantId", (Object)this.getTenantId()).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("description", (Object)this.description).add("rules", this.getRules()).toString();
    }

    public static class Builder {
        private String id;
        private String tenantId;
        private String name;
        private String description;
        private Set<SecurityGroupRule> rules = ImmutableSet.of();

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder rules(SecurityGroupRule ... rules) {
            return this.rules((Set<SecurityGroupRule>)ImmutableSet.copyOf((Object[])((Object[])Preconditions.checkNotNull((Object)rules, (Object)"rules"))));
        }

        public Builder rules(Iterable<SecurityGroupRule> rules) {
            this.rules = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(rules, (Object)"rules")));
            return this;
        }

        public Builder rules(Set<SecurityGroupRule> rules) {
            this.rules = rules;
            return this;
        }

        public SecurityGroup build() {
            return new SecurityGroup(this.id, this.tenantId, this.name, this.description, this.rules);
        }

        public Builder fromSecurityGroup(SecurityGroup in) {
            return this.id(in.getId()).tenantId(in.getTenantId()).name(in.getName()).description(in.getDescription()).rules(in.getRules());
        }
    }
}

