/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.domain;

import com.google.common.base.Objects;
import com.google.gson.annotations.SerializedName;
import org.jclouds.javax.annotation.Nullable;

public class ServerExtendedStatus {
    public static final String PREFIX = "OS-EXT-STS:";
    @SerializedName(value="OS-EXT-STS:task_state")
    private String taskState;
    @SerializedName(value="OS-EXT-STS:vm_state")
    private String vmState;
    @SerializedName(value="OS-EXT-STS:power_state")
    private int powerState = Integer.MIN_VALUE;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromServerExtendedStatus(this);
    }

    protected ServerExtendedStatus() {
    }

    protected ServerExtendedStatus(Builder<?> builder) {
        this.taskState = ((Builder)builder).taskState;
        this.vmState = ((Builder)builder).vmState;
        this.powerState = ((Builder)builder).powerState;
    }

    @Nullable
    public String getTaskState() {
        return this.taskState;
    }

    @Nullable
    public String getVmState() {
        return this.vmState;
    }

    public int getPowerState() {
        return this.powerState;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.taskState, this.vmState, this.powerState});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ServerExtendedStatus that = (ServerExtendedStatus)ServerExtendedStatus.class.cast(obj);
        return Objects.equal((Object)this.taskState, (Object)that.taskState) && Objects.equal((Object)this.vmState, (Object)that.vmState) && Objects.equal((Object)this.powerState, (Object)that.powerState);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((String)"").add("taskState", (Object)this.taskState).add("vmState", (Object)this.vmState).add("powerState", this.powerState);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        private String taskState;
        private String vmState;
        private int powerState = Integer.MIN_VALUE;

        protected abstract T self();

        public T taskState(String taskState) {
            this.taskState = taskState;
            return this.self();
        }

        public T vmState(String vmState) {
            this.vmState = vmState;
            return this.self();
        }

        public T powerState(int powerState) {
            this.powerState = powerState;
            return this.self();
        }

        public ServerExtendedStatus build() {
            return new ServerExtendedStatus(this);
        }

        public T fromServerExtendedStatus(ServerExtendedStatus in) {
            return ((Builder)((Builder)this.taskState(in.getTaskState())).vmState(in.getVmState())).powerState(in.getPowerState());
        }
    }
}

