/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.gson.annotations.SerializedName;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jclouds.openstack.nova.v2_0.domain.Server;

public class ServerWithSecurityGroups
extends Server {
    @SerializedName(value="security_groups")
    private Set<String> securityGroupNames = ImmutableSet.of();

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    @Override
    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromServerWithSecurityGroups(this);
    }

    protected ServerWithSecurityGroups() {
    }

    protected ServerWithSecurityGroups(Builder<?> builder) {
        super(builder);
        this.securityGroupNames = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull((Object)((Builder)builder).securityGroupNames, (Object)"securityGroupNames")));
    }

    public Set<String> getSecurityGroupNames() {
        return Collections.unmodifiableSet(this.securityGroupNames);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.securityGroupNames});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ServerWithSecurityGroups that = (ServerWithSecurityGroups)((Object)ServerWithSecurityGroups.class.cast(obj));
        return super.equals((Object)that) && Objects.equal(this.securityGroupNames, that.securityGroupNames);
    }

    @Override
    protected Objects.ToStringHelper string() {
        return super.string().add("securityGroupNames", this.securityGroupNames);
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>>
    extends Server.Builder<T> {
        private Set<String> securityGroupNames = ImmutableSet.of();

        public T securityGroupNames(Set<String> securityGroupNames) {
            this.securityGroupNames = securityGroupNames;
            return (T)((Object)((Builder)this.self()));
        }

        @Override
        public ServerWithSecurityGroups build() {
            return new ServerWithSecurityGroups(this);
        }

        public T fromServerWithSecurityGroups(ServerWithSecurityGroups in) {
            return ((Builder)((Object)super.fromServer(in))).securityGroupNames(in.getSecurityGroupNames());
        }
    }
}

