/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.gson.annotations.SerializedName;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.nova.v2_0.domain.SimpleServerUsage;

public class SimpleTenantUsage {
    @SerializedName(value="tenant_id")
    private String tenantId;
    @SerializedName(value="total_local_gb_usage")
    private double totalLocalGbUsage;
    @SerializedName(value="total_vcpus_usage")
    private double totalVcpusUsage;
    @SerializedName(value="total_memory_mb_usage")
    private double totalMemoryMbUsage;
    @SerializedName(value="total_hours")
    private double totalHours;
    private Date start;
    private Date stop;
    @SerializedName(value="server_usages")
    private Set<SimpleServerUsage> serverUsages = ImmutableSet.of();

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromSimpleTenantUsage(this);
    }

    protected SimpleTenantUsage() {
    }

    private SimpleTenantUsage(Builder<?> builder) {
        this.tenantId = ((Builder)builder).tenantId;
        this.totalLocalGbUsage = ((Builder)builder).totalLocalGbUsage;
        this.totalVcpusUsage = ((Builder)builder).totalVcpusUsage;
        this.totalMemoryMbUsage = ((Builder)builder).totalMemoryMbUsage;
        this.totalHours = ((Builder)builder).totalHours;
        this.start = ((Builder)builder).start;
        this.stop = ((Builder)builder).stop;
        this.serverUsages = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull((Object)((Builder)builder).serverUsages, (Object)"serverUsages")));
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public double getTotalLocalGbUsage() {
        return this.totalLocalGbUsage;
    }

    public double getTotalVcpusUsage() {
        return this.totalVcpusUsage;
    }

    public double getTotalMemoryMbUsage() {
        return this.totalMemoryMbUsage;
    }

    public double getTotalHours() {
        return this.totalHours;
    }

    @Nullable
    public Date getStart() {
        return this.start;
    }

    @Nullable
    public Date getStop() {
        return this.stop;
    }

    @Nullable
    public Set<SimpleServerUsage> getServerUsages() {
        return this.serverUsages == null ? ImmutableSet.of() : Collections.unmodifiableSet(this.serverUsages);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.totalLocalGbUsage, this.totalVcpusUsage, this.totalMemoryMbUsage, this.totalHours, this.start, this.stop, this.serverUsages});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleTenantUsage that = (SimpleTenantUsage)SimpleTenantUsage.class.cast(obj);
        return Objects.equal((Object)this.totalLocalGbUsage, (Object)that.totalLocalGbUsage) && Objects.equal((Object)this.totalVcpusUsage, (Object)that.totalVcpusUsage) && Objects.equal((Object)this.totalMemoryMbUsage, (Object)that.totalMemoryMbUsage) && Objects.equal((Object)this.totalHours, (Object)that.totalHours) && Objects.equal((Object)this.start, (Object)that.start) && Objects.equal((Object)this.stop, (Object)that.stop) && Objects.equal(this.serverUsages, that.serverUsages);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((String)"").add("totalLocalGbUsage", this.totalLocalGbUsage).add("totalVcpusUsage", this.totalVcpusUsage).add("totalMemoryMbUsage", this.totalMemoryMbUsage).add("totalHours", this.totalHours).add("start", (Object)this.start).add("stop", (Object)this.stop).add("serverUsages", this.serverUsages);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        private String tenantId;
        private double totalLocalGbUsage;
        private double totalVcpusUsage;
        private double totalMemoryMbUsage;
        private double totalHours;
        private Date start;
        private Date stop;
        private Set<SimpleServerUsage> serverUsages = Sets.newLinkedHashSet();

        protected abstract T self();

        public T tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this.self();
        }

        public T totalLocalGbUsage(double total_local_gb_usage) {
            this.totalLocalGbUsage = total_local_gb_usage;
            return this.self();
        }

        public T totalVcpusUsage(double total_vcpus_usage) {
            this.totalVcpusUsage = total_vcpus_usage;
            return this.self();
        }

        public T totalMemoryMbUsage(double total_memory_mb_usage) {
            this.totalMemoryMbUsage = total_memory_mb_usage;
            return this.self();
        }

        public T totalHours(double total_hours) {
            this.totalHours = total_hours;
            return this.self();
        }

        public T start(Date start) {
            this.start = start;
            return this.self();
        }

        public T stop(Date stop) {
            this.stop = stop;
            return this.self();
        }

        public T serverUsages(Set<SimpleServerUsage> serverUsages) {
            this.serverUsages = serverUsages;
            return this.self();
        }

        public SimpleTenantUsage build() {
            return new SimpleTenantUsage(this);
        }

        public T fromSimpleTenantUsage(SimpleTenantUsage in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.totalLocalGbUsage(in.getTotalLocalGbUsage())).totalVcpusUsage(in.getTotalVcpusUsage())).totalMemoryMbUsage(in.getTotalMemoryMbUsage())).totalHours(in.getTotalHours())).start(in.getStart())).stop(in.getStop())).serverUsages(in.getServerUsages());
        }
    }
}

