/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.domain;

import com.google.common.base.CaseFormat;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.annotations.SerializedName;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.nova.v2_0.domain.VolumeAttachment;

public class Volume {
    private String id;
    private Status status;
    private int size;
    @SerializedName(value="availabilityZone")
    private String zone;
    @SerializedName(value="createdAt")
    private Date created;
    private Set<VolumeAttachment> attachments = ImmutableSet.of();
    private String volumeType;
    private String snapshotId;
    @SerializedName(value="displayName")
    private String name;
    @SerializedName(value="displayDescription")
    private String description;
    private Map<String, String> metadata = ImmutableMap.of();

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromVolume(this);
    }

    protected Volume() {
    }

    protected Volume(Builder<?> builder) {
        this.id = ((Builder)builder).id;
        this.status = ((Builder)builder).status;
        this.size = ((Builder)builder).size;
        this.zone = ((Builder)builder).zone;
        this.created = ((Builder)builder).created;
        this.attachments = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull((Object)((Builder)builder).attachments, (Object)"attachments")));
        this.volumeType = ((Builder)builder).volumeType;
        this.snapshotId = ((Builder)builder).snapshotId;
        this.name = ((Builder)builder).name;
        this.description = ((Builder)builder).description;
        this.metadata = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull((Object)((Builder)builder).metadata, (Object)"metadata")));
    }

    public String getId() {
        return this.id;
    }

    public Status getStatus() {
        return this.status;
    }

    public int getSize() {
        return this.size;
    }

    public String getZone() {
        return this.zone;
    }

    public Date getCreated() {
        return this.created;
    }

    @Nullable
    public Set<VolumeAttachment> getAttachments() {
        return Collections.unmodifiableSet(this.attachments);
    }

    @Nullable
    public String getVolumeType() {
        return this.volumeType;
    }

    @Nullable
    public String getSnapshotId() {
        return this.snapshotId;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public Map<String, String> getMetadata() {
        return Collections.unmodifiableMap(this.metadata);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.zone});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Volume that = (Volume)Volume.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.zone, (Object)that.zone);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((String)"").add("id", (Object)this.id).add("status", (Object)this.status).add("size", this.size).add("zone", (Object)this.zone).add("created", (Object)this.created).add("attachments", this.attachments).add("volumeType", (Object)this.volumeType).add("snapshotId", (Object)this.snapshotId).add("name", (Object)this.name).add("description", (Object)this.description).add("metadata", this.metadata);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        private String id;
        private Status status;
        private int size;
        private String zone;
        private Date created;
        private Set<VolumeAttachment> attachments = Sets.newLinkedHashSet();
        private String volumeType;
        private String snapshotId;
        private String name;
        private String description;
        private Map<String, String> metadata = Maps.newHashMap();

        protected abstract T self();

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T status(Status status) {
            this.status = status;
            return this.self();
        }

        public T size(int size) {
            this.size = size;
            return this.self();
        }

        public T zone(String zone) {
            this.zone = zone;
            return this.self();
        }

        public T created(Date created) {
            this.created = created;
            return this.self();
        }

        public T attachments(Set<VolumeAttachment> attachments) {
            this.attachments = attachments;
            return this.self();
        }

        public T volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this.self();
        }

        public T snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this.self();
        }

        public T metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T description(String description) {
            this.description = description;
            return this.self();
        }

        public Volume build() {
            return new Volume(this);
        }

        public T fromVolume(Volume in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id(in.getId())).status(in.getStatus())).size(in.getSize())).zone(in.getZone())).created(in.getCreated())).attachments(in.getAttachments())).volumeType(in.getVolumeType())).snapshotId(in.getSnapshotId())).metadata(in.getMetadata());
        }
    }

    public static enum Status {
        CREATING,
        AVAILABLE,
        IN_USE,
        DELETING,
        ERROR,
        UNRECOGNIZED;


        public String value() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_HYPHEN, this.name());
        }

        public String toString() {
            return this.value();
        }

        public static Status fromValue(String status) {
            try {
                return Status.valueOf(CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_UNDERSCORE, (String)Preconditions.checkNotNull((Object)status, (Object)"status")));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

