/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.extensions;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.concurrent.Timeout;
import org.jclouds.openstack.keystone.v2_0.filters.AuthenticateRequest;
import org.jclouds.openstack.nova.v2_0.domain.HostAggregate;
import org.jclouds.openstack.v2_0.services.Extension;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.WrapWith;
import org.jclouds.rest.functions.ReturnEmptySetOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnFalseOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;

@Extension(of="compute", namespace="http://docs.openstack.org/ext/aggregates/api/v1.1")
@Timeout(duration=180L, timeUnit=TimeUnit.SECONDS)
@RequestFilters(value={AuthenticateRequest.class})
@Path(value="/os-aggregates")
public interface HostAggregateAsyncClient {
    @GET
    @SelectJson(value="aggregates")
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<Set<HostAggregate>> listAggregates();

    @GET
    @Path(value="/{id}")
    @SelectJson(value="aggregate")
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<HostAggregate> getAggregate(@PathParam(value="id") String var1);

    @POST
    @SelectJson(value="aggregate")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @WrapWith(value="aggregate")
    public ListenableFuture<HostAggregate> createAggregate(@PayloadParam(value="name") String var1, @PayloadParam(value="availability_zone") String var2);

    @POST
    @Path(value="/{id}")
    @SelectJson(value="aggregate")
    @Consumes(value={"application/json"})
    @WrapWith(value="aggregate")
    public ListenableFuture<HostAggregate> updateName(@PathParam(value="id") String var1, @PayloadParam(value="name") String var2);

    @POST
    @Path(value="/{id}")
    @SelectJson(value="aggregate")
    @Consumes(value={"application/json"})
    @WrapWith(value="aggregate")
    public ListenableFuture<HostAggregate> updateAvailabilityZone(@PathParam(value="id") String var1, @PayloadParam(value="availability_zone") String var2);

    @DELETE
    @Path(value="/{id}")
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnFalseOnNotFoundOr404.class)
    public ListenableFuture<Boolean> deleteAggregate(@PathParam(value="id") String var1);

    @POST
    @Path(value="/{id}/action")
    @SelectJson(value="aggregate")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @WrapWith(value="add_host")
    public ListenableFuture<HostAggregate> addHost(@PathParam(value="id") String var1, @PayloadParam(value="host") String var2);

    @POST
    @Path(value="/{id}/action")
    @SelectJson(value="aggregate")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @WrapWith(value="remove_host")
    public ListenableFuture<HostAggregate> removeHost(@PathParam(value="id") String var1, @PayloadParam(value="host") String var2);

    @POST
    @Path(value="/{id}/action")
    @SelectJson(value="aggregate")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @WrapWith(value="set_metadata")
    public ListenableFuture<HostAggregate> setMetadata(@PathParam(value="id") String var1, @PayloadParam(value="metadata") Map<String, String> var2);
}

