/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.features;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.openstack.keystone.v2_0.filters.AuthenticateRequest;
import org.jclouds.openstack.nova.v2_0.domain.RebootType;
import org.jclouds.openstack.nova.v2_0.domain.Server;
import org.jclouds.openstack.nova.v2_0.domain.ServerCreated;
import org.jclouds.openstack.nova.v2_0.functions.ParseImageIdFromLocationHeader;
import org.jclouds.openstack.nova.v2_0.options.CreateServerOptions;
import org.jclouds.openstack.nova.v2_0.options.RebuildServerOptions;
import org.jclouds.openstack.v2_0.domain.Resource;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.annotations.Unwrap;
import org.jclouds.rest.functions.MapHttp4xxCodesToExceptions;
import org.jclouds.rest.functions.ReturnEmptySetOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnFalseOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;

@SkipEncoding(value={47, 61})
@RequestFilters(value={AuthenticateRequest.class})
public interface ServerAsyncClient {
    @GET
    @SelectJson(value="servers")
    @Consumes(value={"application/json"})
    @Path(value="/servers")
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<Set<Resource>> listServers();

    @GET
    @SelectJson(value="servers")
    @Consumes(value={"application/json"})
    @Path(value="/servers/detail")
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<Set<Server>> listServersInDetail();

    @GET
    @SelectJson(value="server")
    @Consumes(value={"application/json"})
    @Path(value="/servers/{id}")
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<Server> getServer(@PathParam(value="id") String var1);

    @DELETE
    @Consumes
    @ExceptionParser(value=ReturnFalseOnNotFoundOr404.class)
    @Path(value="/servers/{id}")
    public ListenableFuture<Boolean> deleteServer(@PathParam(value="id") String var1);

    @POST
    @Path(value="/servers/{id}/action")
    @Consumes
    @Produces(value={"application/json"})
    @Payload(value="%7B\"reboot\":%7B\"type\":\"{type}\"%7D%7D")
    public ListenableFuture<Void> rebootServer(@PathParam(value="id") String var1, @PayloadParam(value="type") RebootType var2);

    @POST
    @Path(value="/servers/{id}/action")
    @Consumes
    @Produces(value={"application/json"})
    @Payload(value="%7B\"resize\":%7B\"flavorId\":{flavorId}%7D%7D")
    public ListenableFuture<Void> resizeServer(@PathParam(value="id") String var1, @PayloadParam(value="flavorId") String var2);

    @POST
    @Path(value="/servers/{id}/action")
    @Consumes
    @Produces(value={"application/json"})
    @Payload(value="{\"confirmResize\":null}")
    public ListenableFuture<Void> confirmResizeServer(@PathParam(value="id") String var1);

    @POST
    @Path(value="/servers/{id}/action")
    @Consumes
    @Produces(value={"application/json"})
    @Payload(value="{\"revertResize\":null}")
    public ListenableFuture<Void> revertResizeServer(@PathParam(value="id") String var1);

    @POST
    @Unwrap
    @Consumes(value={"application/json"})
    @Path(value="/servers")
    @MapBinder(value=CreateServerOptions.class)
    public ListenableFuture<ServerCreated> createServer(@PayloadParam(value="name") String var1, @PayloadParam(value="imageRef") String var2, @PayloadParam(value="flavorRef") String var3, CreateServerOptions ... var4);

    @POST
    @Path(value="/servers/{id}/action")
    @Consumes
    @MapBinder(value=RebuildServerOptions.class)
    public ListenableFuture<Void> rebuildServer(@PathParam(value="id") String var1, RebuildServerOptions ... var2);

    @POST
    @Path(value="/servers/{id}/action")
    @Consumes
    @Produces(value={"application/json"})
    @Payload(value="%7B\"changePassword\":%7B\"adminPass\":\"{adminPass}\"%7D%7D")
    public ListenableFuture<Void> changeAdminPass(@PathParam(value="id") String var1, @PayloadParam(value="adminPass") String var2);

    @PUT
    @Path(value="/servers/{id}")
    @Consumes
    @Produces(value={"application/json"})
    @Payload(value="%7B\"server\":%7B\"name\":\"{name}\"%7D%7D")
    public ListenableFuture<Void> renameServer(@PathParam(value="id") String var1, @PayloadParam(value="name") String var2);

    @POST
    @Path(value="/servers/{id}/action")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Payload(value="%7B\"createImage\":%7B\"name\":\"{name}\", \"metadata\": %7B%7D%7D%7D")
    @ExceptionParser(value=MapHttp4xxCodesToExceptions.class)
    @ResponseParser(value=ParseImageIdFromLocationHeader.class)
    public ListenableFuture<String> createImageFromServer(@PayloadParam(value="name") String var1, @PathParam(value="id") String var2);
}

