/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.options;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.encryption.internal.Base64;
import org.jclouds.http.HttpRequest;
import org.jclouds.openstack.nova.v2_0.domain.SecurityGroup;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.binders.BindToJsonPayload;
import org.jclouds.util.Preconditions2;

public class CreateServerOptions
implements MapBinder {
    @Inject
    private BindToJsonPayload jsonBinder;
    private String keyName;
    private String adminPass;
    private Set<String> securityGroupNames = ImmutableSet.of();
    private Map<String, String> metadata = ImmutableMap.of();
    private List<File> personality = Lists.newArrayList();
    private byte[] userData;

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof CreateServerOptions) {
            CreateServerOptions other = (CreateServerOptions)CreateServerOptions.class.cast(object);
            return Objects.equal((Object)this.keyName, (Object)other.keyName) && Objects.equal(this.securityGroupNames, other.securityGroupNames) && Objects.equal(this.metadata, other.metadata) && Objects.equal(this.personality, other.personality) && Objects.equal((Object)this.adminPass, (Object)other.adminPass);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.keyName, this.securityGroupNames, this.metadata, this.personality, this.adminPass});
    }

    protected Objects.ToStringHelper string() {
        Objects.ToStringHelper toString = Objects.toStringHelper((String)"").omitNullValues();
        toString.add("keyName", (Object)this.keyName);
        if (this.securityGroupNames.size() > 0) {
            toString.add("securityGroupNames", this.securityGroupNames);
        }
        if (this.metadata.size() > 0) {
            toString.add("metadata", this.metadata);
        }
        if (this.personality.size() > 0) {
            toString.add("personality", this.personality);
        }
        if (this.adminPass != null) {
            toString.add("adminPassPresent", true);
        }
        toString.add("userData", (Object)(this.userData == null ? null : new String(this.userData)));
        return toString;
    }

    public String toString() {
        return this.string().toString();
    }

    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        ServerRequest server = new ServerRequest(Preconditions.checkNotNull((Object)postParams.get("name"), (Object)"name parameter not present").toString(), Preconditions.checkNotNull((Object)postParams.get("imageRef"), (Object)"imageRef parameter not present").toString(), Preconditions.checkNotNull((Object)postParams.get("flavorRef"), (Object)"flavorRef parameter not present").toString());
        if (this.metadata.size() > 0) {
            server.metadata = this.metadata;
        }
        if (this.personality.size() > 0) {
            server.personality = this.personality;
        }
        if (this.keyName != null) {
            server.key_name = this.keyName;
        }
        if (this.userData != null) {
            server.user_data = Base64.encodeBytes((byte[])this.userData);
        }
        if (this.securityGroupNames.size() > 0) {
            server.securityGroupNames = Sets.newHashSet();
            for (String groupName : this.securityGroupNames) {
                SecurityGroup group = SecurityGroup.builder().name(groupName).build();
                server.securityGroupNames.add(group);
            }
        }
        if (this.adminPass != null) {
            server.adminPass = this.adminPass;
        }
        return this.bindToRequest(request, ImmutableMap.of((Object)"server", (Object)server));
    }

    public CreateServerOptions writeFileToPath(byte[] contents, String path) {
        Preconditions.checkState((this.personality.size() < 5 ? 1 : 0) != 0, (Object)"maximum number of files allowed is 5");
        this.personality.add(new File(path, contents));
        return this;
    }

    public CreateServerOptions adminPass(String adminPass) {
        Preconditions.checkNotNull((Object)adminPass, (Object)"adminPass");
        this.adminPass = adminPass;
        return this;
    }

    public CreateServerOptions metadata(Map<String, String> metadata) {
        Preconditions.checkNotNull(metadata, (Object)"metadata");
        Preconditions.checkArgument((metadata.size() <= 5 ? 1 : 0) != 0, (Object)("you cannot have more then 5 metadata values.  You specified: " + metadata.size()));
        for (Map.Entry<String, String> entry : metadata.entrySet()) {
            Preconditions.checkArgument((entry.getKey().getBytes().length < 255 ? 1 : 0) != 0, (Object)String.format("maximum length of metadata key is 255 bytes.  Key specified %s is %d bytes", entry.getKey(), entry.getKey().getBytes().length));
            Preconditions.checkArgument((entry.getKey().getBytes().length < 255 ? 1 : 0) != 0, (Object)String.format("maximum length of metadata value is 255 bytes.  Value specified for %s (%s) is %d bytes", entry.getKey(), entry.getValue(), entry.getValue().getBytes().length));
        }
        this.metadata = ImmutableMap.copyOf(metadata);
        return this;
    }

    public CreateServerOptions userData(byte[] userData) {
        this.userData = userData;
        return this;
    }

    public String getKeyPairName() {
        return this.keyName;
    }

    public CreateServerOptions keyPairName(String keyName) {
        this.keyName = keyName;
        return this;
    }

    public Set<String> getSecurityGroupNames() {
        return this.securityGroupNames;
    }

    public CreateServerOptions securityGroupNames(String ... securityGroupNames) {
        return this.securityGroupNames((Iterable<String>)ImmutableSet.copyOf((Object[])((Object[])Preconditions.checkNotNull((Object)securityGroupNames, (Object)"securityGroupNames"))));
    }

    public CreateServerOptions securityGroupNames(Iterable<String> securityGroupNames) {
        for (String groupName : (Iterable)Preconditions.checkNotNull(securityGroupNames, (Object)"securityGroupNames")) {
            Preconditions2.checkNotEmpty((String)groupName, (String)"all security groups must be non-empty");
        }
        this.securityGroupNames = ImmutableSet.copyOf(securityGroupNames);
        return this;
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        return (R)this.jsonBinder.bindToRequest(request, input);
    }

    public static class Builder {
        public static CreateServerOptions writeFileToPath(byte[] contents, String path) {
            CreateServerOptions options = new CreateServerOptions();
            return options.writeFileToPath(contents, path);
        }

        public static CreateServerOptions adminPass(String adminPass) {
            CreateServerOptions options = new CreateServerOptions();
            return options.adminPass(adminPass);
        }

        public static CreateServerOptions metadata(Map<String, String> metadata) {
            CreateServerOptions options = new CreateServerOptions();
            return options.metadata(metadata);
        }

        public static CreateServerOptions keyPairName(String keyName) {
            CreateServerOptions options = new CreateServerOptions();
            return options.keyPairName(keyName);
        }

        public static CreateServerOptions securityGroupNames(String ... groupNames) {
            CreateServerOptions options = new CreateServerOptions();
            return (CreateServerOptions)CreateServerOptions.class.cast(options.securityGroupNames(groupNames));
        }

        public static CreateServerOptions securityGroupNames(Iterable<String> groupNames) {
            CreateServerOptions options = new CreateServerOptions();
            return (CreateServerOptions)CreateServerOptions.class.cast(options.securityGroupNames(groupNames));
        }
    }

    private class ServerRequest {
        final String name;
        final String imageRef;
        final String flavorRef;
        String adminPass;
        Map<String, String> metadata;
        List<File> personality;
        String key_name;
        @SerializedName(value="security_groups")
        Set<SecurityGroup> securityGroupNames;
        String user_data;

        private ServerRequest(String name, String imageRef, String flavorRef) {
            this.name = name;
            this.imageRef = imageRef;
            this.flavorRef = flavorRef;
        }
    }

    static class File {
        private final String path;
        private final String contents;

        public File(String path, byte[] contents) {
            this.path = (String)Preconditions.checkNotNull((Object)path, (Object)"path");
            this.contents = Base64.encodeBytes((byte[])((byte[])Preconditions.checkNotNull((Object)contents, (Object)"contents")));
            Preconditions.checkArgument((path.getBytes().length < 255 ? 1 : 0) != 0, (Object)String.format("maximum length of path is 255 bytes.  Path specified %s is %d bytes", path, path.getBytes().length));
            Preconditions.checkArgument((contents.length < 10240 ? 1 : 0) != 0, (Object)String.format("maximum size of the file is 10KB.  Contents specified is %d bytes", contents.length));
        }

        public String getContents() {
            return this.contents;
        }

        public String getPath() {
            return this.path;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof File) {
                File other = (File)File.class.cast(object);
                return Objects.equal((Object)this.path, (Object)other.path);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.path});
        }

        public String toString() {
            return Objects.toStringHelper((String)"file").add("path", (Object)this.path).toString();
        }
    }
}

