/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.net.URI;
import java.util.Collection;
import org.jclouds.openstack.nova.v2_0.domain.Extension;

public class ExtensionPredicates {
    public static Predicate<Extension> namespaceEquals(final URI namespace) {
        Preconditions.checkNotNull((Object)namespace, (Object)"namespace must be defined");
        return new Predicate<Extension>(){

            public boolean apply(Extension ext) {
                return namespace.toASCIIString().equals(ext.getNamespace().toASCIIString().replace("https", "http"));
            }

            public String toString() {
                return "namespaceEquals(" + namespace + ")";
            }
        };
    }

    public static Predicate<Extension> aliasEquals(final String alias) {
        Preconditions.checkNotNull((Object)alias, (Object)"alias must be defined");
        return new Predicate<Extension>(){

            public boolean apply(Extension ext) {
                return alias.equals(ext.getAlias());
            }

            public String toString() {
                return "aliasEquals(" + alias + ")";
            }
        };
    }

    public static Predicate<Extension> namespaceOrAliasEquals(final URI namespace, final Collection<URI> namespaceAliases) {
        Preconditions.checkNotNull((Object)namespace, (Object)"namespace must be defined");
        Preconditions.checkNotNull(namespaceAliases, (Object)"namespace aliases must be defined");
        return new Predicate<Extension>(){

            public boolean apply(Extension ext) {
                return namespace.toASCIIString().equals(ext.getNamespace().toASCIIString().replace("https", "http")) || namespaceAliases.contains(ext.getNamespace());
            }

            public String toString() {
                return "namespaceOrAliasEquals(" + namespace + ")";
            }
        };
    }
}

