/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import org.jclouds.openstack.nova.v2_0.domain.SecurityGroup;

public class SecurityGroupPredicates {
    public static Predicate<SecurityGroup> nameEquals(final String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name must be defined");
        return new Predicate<SecurityGroup>(){

            public boolean apply(SecurityGroup ext) {
                return name.equals(ext.getName());
            }

            public String toString() {
                return "nameEquals(" + name + ")";
            }
        };
    }

    public static Predicate<SecurityGroup> nameMatches(final Predicate<String> name) {
        Preconditions.checkNotNull(name, (Object)"name must be defined");
        return new Predicate<SecurityGroup>(){

            public boolean apply(SecurityGroup ext) {
                return name.apply((Object)ext.getName());
            }

            public String toString() {
                return "nameMatches(" + name + ")";
            }
        };
    }
}

