/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.config.ComputeServiceAdapterContextModule;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.extensions.ImageExtension;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.strategy.impl.CreateNodesWithGroupEncodedIntoNameThenAddToSet;
import org.jclouds.domain.Location;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.functions.IdentityFunction;
import org.jclouds.openstack.nova.v2_0.compute.NovaComputeService;
import org.jclouds.openstack.nova.v2_0.compute.NovaComputeServiceAdapter;
import org.jclouds.openstack.nova.v2_0.compute.extensions.NovaImageExtension;
import org.jclouds.openstack.nova.v2_0.compute.functions.CreateSecurityGroupIfNeeded;
import org.jclouds.openstack.nova.v2_0.compute.functions.FlavorInZoneToHardware;
import org.jclouds.openstack.nova.v2_0.compute.functions.ImageInZoneToImage;
import org.jclouds.openstack.nova.v2_0.compute.functions.ImageToOperatingSystem;
import org.jclouds.openstack.nova.v2_0.compute.functions.OrphanedGroupsByZoneId;
import org.jclouds.openstack.nova.v2_0.compute.functions.ServerInZoneToNodeMetadata;
import org.jclouds.openstack.nova.v2_0.compute.loaders.CreateUniqueKeyPair;
import org.jclouds.openstack.nova.v2_0.compute.loaders.FindSecurityGroupOrCreate;
import org.jclouds.openstack.nova.v2_0.compute.loaders.LoadFloatingIpsForInstance;
import org.jclouds.openstack.nova.v2_0.compute.options.NovaTemplateOptions;
import org.jclouds.openstack.nova.v2_0.compute.predicates.GetImageWhenImageInZoneHasActiveStatusPredicateWithResult;
import org.jclouds.openstack.nova.v2_0.compute.strategy.ApplyNovaTemplateOptionsCreateNodesWithGroupEncodedIntoNameThenAddToSet;
import org.jclouds.openstack.nova.v2_0.domain.Image;
import org.jclouds.openstack.nova.v2_0.domain.KeyPair;
import org.jclouds.openstack.nova.v2_0.domain.Server;
import org.jclouds.openstack.nova.v2_0.domain.zonescoped.FlavorInZone;
import org.jclouds.openstack.nova.v2_0.domain.zonescoped.ImageInZone;
import org.jclouds.openstack.nova.v2_0.domain.zonescoped.SecurityGroupInZone;
import org.jclouds.openstack.nova.v2_0.domain.zonescoped.ServerInZone;
import org.jclouds.openstack.nova.v2_0.domain.zonescoped.ZoneAndId;
import org.jclouds.openstack.nova.v2_0.domain.zonescoped.ZoneAndName;
import org.jclouds.openstack.nova.v2_0.domain.zonescoped.ZoneSecurityGroupNameAndPorts;
import org.jclouds.openstack.nova.v2_0.predicates.FindSecurityGroupWithNameAndReturnTrue;
import org.jclouds.predicates.PredicateWithResult;
import org.jclouds.predicates.RetryablePredicate;
import org.jclouds.util.Suppliers2;

public class NovaComputeServiceContextModule
extends ComputeServiceAdapterContextModule<ServerInZone, FlavorInZone, ImageInZone, Location> {
    @VisibleForTesting
    public static final Map<Server.Status, NodeMetadata.Status> toPortableNodeStatus = ImmutableMap.builder().put((Object)Server.Status.ACTIVE, (Object)NodeMetadata.Status.RUNNING).put((Object)Server.Status.SUSPENDED, (Object)NodeMetadata.Status.SUSPENDED).put((Object)Server.Status.DELETED, (Object)NodeMetadata.Status.TERMINATED).put((Object)Server.Status.PAUSED, (Object)NodeMetadata.Status.SUSPENDED).put((Object)Server.Status.RESIZE, (Object)NodeMetadata.Status.PENDING).put((Object)Server.Status.VERIFY_RESIZE, (Object)NodeMetadata.Status.PENDING).put((Object)Server.Status.REVERT_RESIZE, (Object)NodeMetadata.Status.PENDING).put((Object)Server.Status.BUILD, (Object)NodeMetadata.Status.PENDING).put((Object)Server.Status.PASSWORD, (Object)NodeMetadata.Status.PENDING).put((Object)Server.Status.REBUILD, (Object)NodeMetadata.Status.PENDING).put((Object)Server.Status.ERROR, (Object)NodeMetadata.Status.ERROR).put((Object)Server.Status.REBOOT, (Object)NodeMetadata.Status.PENDING).put((Object)Server.Status.HARD_REBOOT, (Object)NodeMetadata.Status.PENDING).put((Object)Server.Status.UNKNOWN, (Object)NodeMetadata.Status.UNRECOGNIZED).put((Object)Server.Status.UNRECOGNIZED, (Object)NodeMetadata.Status.UNRECOGNIZED).build();
    @VisibleForTesting
    public static final Map<Image.Status, Image.Status> toPortableImageStatus = ImmutableMap.builder().put((Object)Image.Status.ACTIVE, (Object)Image.Status.AVAILABLE).put((Object)Image.Status.SAVING, (Object)Image.Status.PENDING).put((Object)Image.Status.DELETED, (Object)Image.Status.DELETED).put((Object)Image.Status.ERROR, (Object)Image.Status.ERROR).put((Object)Image.Status.UNKNOWN, (Object)Image.Status.UNRECOGNIZED).put((Object)Image.Status.UNRECOGNIZED, (Object)Image.Status.UNRECOGNIZED).build();

    protected void configure() {
        super.configure();
        this.bind((TypeLiteral)new TypeLiteral<ComputeServiceAdapter<ServerInZone, FlavorInZone, ImageInZone, Location>>(){}).to(NovaComputeServiceAdapter.class);
        this.bind(ComputeService.class).to(NovaComputeService.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<ServerInZone, NodeMetadata>>(){}).to(ServerInZoneToNodeMetadata.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Set<? extends NodeMetadata>, Multimap<String, String>>>(){}).to(OrphanedGroupsByZoneId.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<ImageInZone, Image>>(){}).to(ImageInZoneToImage.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<org.jclouds.openstack.nova.v2_0.domain.Image, OperatingSystem>>(){}).to(ImageToOperatingSystem.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<FlavorInZone, Hardware>>(){}).to(FlavorInZoneToHardware.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Location, Location>>(){}).to((Class)Class.class.cast(IdentityFunction.class));
        this.bind(TemplateOptions.class).to(NovaTemplateOptions.class);
        this.bind((TypeLiteral)new TypeLiteral<CacheLoader<ZoneAndId, Iterable<String>>>(){}).annotatedWith((Annotation)Names.named((String)"FLOATINGIP")).to(LoadFloatingIpsForInstance.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<ZoneSecurityGroupNameAndPorts, SecurityGroupInZone>>(){}).to(CreateSecurityGroupIfNeeded.class);
        this.bind((TypeLiteral)new TypeLiteral<CacheLoader<ZoneAndName, SecurityGroupInZone>>(){}).to(FindSecurityGroupOrCreate.class);
        this.bind(CreateNodesWithGroupEncodedIntoNameThenAddToSet.class).to(ApplyNovaTemplateOptionsCreateNodesWithGroupEncodedIntoNameThenAddToSet.class);
        this.bind((TypeLiteral)new TypeLiteral<CacheLoader<ZoneAndName, KeyPair>>(){}).to(CreateUniqueKeyPair.class);
        this.bind((TypeLiteral)new TypeLiteral<ImageExtension>(){}).to(NovaImageExtension.class);
        this.bind((TypeLiteral)new TypeLiteral<PredicateWithResult<ZoneAndId, Image>>(){}).to(GetImageWhenImageInZoneHasActiveStatusPredicateWithResult.class);
    }

    protected TemplateOptions provideTemplateOptions(Injector injector, TemplateOptions options) {
        return ((NovaTemplateOptions)options.as(NovaTemplateOptions.class)).autoAssignFloatingIp((Boolean)injector.getInstance(Key.get(Boolean.TYPE, (Annotation)Names.named((String)"jclouds.openstack-nova.auto-allocate-floating-ips")))).generateKeyPair((Boolean)injector.getInstance(Key.get(Boolean.TYPE, (Annotation)Names.named((String)"jclouds.openstack-nova.auto-generate-keypairs"))));
    }

    @Provides
    @Singleton
    @Named(value="FLOATINGIP")
    protected LoadingCache<ZoneAndId, Iterable<String>> instanceToFloatingIps(@Named(value="FLOATINGIP") CacheLoader<ZoneAndId, Iterable<String>> in) {
        return CacheBuilder.newBuilder().build(in);
    }

    @Provides
    @Singleton
    protected LoadingCache<ZoneAndName, SecurityGroupInZone> securityGroupMap(CacheLoader<ZoneAndName, SecurityGroupInZone> in) {
        return CacheBuilder.newBuilder().build(in);
    }

    protected Map<OsFamily, LoginCredentials> osFamilyToCredentials(Injector injector) {
        return ImmutableMap.of((Object)OsFamily.WINDOWS, (Object)LoginCredentials.builder().user("Administrator").build(), (Object)OsFamily.UBUNTU, (Object)LoginCredentials.builder().user("ubuntu").build());
    }

    @Provides
    @Singleton
    @Named(value="jclouds.openstack-nova.timeout.securitygroup-present")
    protected Predicate<AtomicReference<ZoneAndName>> securityGroupEventualConsistencyDelay(FindSecurityGroupWithNameAndReturnTrue in, @Named(value="jclouds.openstack-nova.timeout.securitygroup-present") long msDelay) {
        return new RetryablePredicate((Predicate)in, msDelay, 100L, TimeUnit.MILLISECONDS);
    }

    @Provides
    @Singleton
    protected LoadingCache<ZoneAndName, KeyPair> keyPairMap(CacheLoader<ZoneAndName, KeyPair> in) {
        return CacheBuilder.newBuilder().build(in);
    }

    @Provides
    @Singleton
    protected Supplier<Map<String, Location>> createLocationIndexedById(@Memoized Supplier<Set<? extends Location>> locations) {
        return Suppliers2.compose((Function)new Function<Set<? extends Location>, Map<String, Location>>(){

            public Map<String, Location> apply(Set<? extends Location> arg0) {
                Set<? extends Location> locations = arg0;
                return Maps.uniqueIndex(locations, (Function)new Function<Location, String>(){

                    public String apply(Location arg0) {
                        return arg0.getId();
                    }
                });
            }
        }, locations);
    }

    @Singleton
    @Provides
    protected Map<Server.Status, NodeMetadata.Status> toPortableNodeStatus() {
        return toPortableNodeStatus;
    }

    @Singleton
    @Provides
    protected Map<Image.Status, Image.Status> toPortableImageStatus() {
        return toPortableImageStatus;
    }

    protected Optional<ImageExtension> provideImageExtension(Injector i) {
        return Optional.of((Object)i.getInstance(ImageExtension.class));
    }
}

