/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.util.Set;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.v2_0.domain.Link;
import org.jclouds.openstack.v2_0.domain.Resource;

public class ServerCreated
extends Resource {
    private final String adminPass;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromServerCreated(this);
    }

    @ConstructorProperties(value={"id", "name", "links", "adminPass"})
    protected ServerCreated(String id, @Nullable String name, Set<Link> links, String adminPass) {
        super(id, name, links);
        this.adminPass = (String)Preconditions.checkNotNull((Object)adminPass, (Object)"adminPass");
    }

    public String getAdminPass() {
        return this.adminPass;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.adminPass});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ServerCreated that = (ServerCreated)((Object)ServerCreated.class.cast(obj));
        return super.equals((Object)that) && Objects.equal((Object)this.adminPass, (Object)that.adminPass);
    }

    protected Objects.ToStringHelper string() {
        return super.string().add("adminPass", (Object)this.adminPass);
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>>
    extends Resource.Builder<T> {
        protected String adminPass;

        public T adminPass(String adminPass) {
            this.adminPass = adminPass;
            return (T)((Object)((Builder)this.self()));
        }

        public ServerCreated build() {
            return new ServerCreated(this.id, this.name, this.links, this.adminPass);
        }

        public T fromServerCreated(ServerCreated in) {
            return ((Builder)super.fromResource((Resource)in)).adminPass(in.getAdminPass());
        }
    }
}

