/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.domain.Location;
import org.jclouds.openstack.nova.v2_0.domain.Image;
import org.jclouds.openstack.nova.v2_0.domain.zonescoped.ImageInZone;

public class ImageInZoneToImage
implements Function<ImageInZone, Image> {
    private final Map<Image.Status, Image.Status> toPortableImageStatus;
    private final Function<org.jclouds.openstack.nova.v2_0.domain.Image, OperatingSystem> imageToOs;
    private final Supplier<Map<String, Location>> locationIndex;

    @Inject
    public ImageInZoneToImage(Map<Image.Status, Image.Status> toPortableImageStatus, Function<org.jclouds.openstack.nova.v2_0.domain.Image, OperatingSystem> imageToOs, Supplier<Map<String, Location>> locationIndex) {
        this.toPortableImageStatus = (Map)Preconditions.checkNotNull(toPortableImageStatus, (Object)"toPortableImageStatus");
        this.imageToOs = (Function)Preconditions.checkNotNull(imageToOs, (Object)"imageToOs");
        this.locationIndex = (Supplier)Preconditions.checkNotNull(locationIndex, (Object)"locationIndex");
    }

    public Image apply(ImageInZone imageInZone) {
        Location location = (Location)((Map)this.locationIndex.get()).get(imageInZone.getZone());
        Preconditions.checkState((location != null ? 1 : 0) != 0, (String)"location %s not in locationIndex: %s", (Object[])new Object[]{imageInZone.getZone(), this.locationIndex.get()});
        org.jclouds.openstack.nova.v2_0.domain.Image image = imageInZone.getImage();
        return new ImageBuilder().id(imageInZone.slashEncode()).providerId(image.getId()).name(image.getName()).userMetadata(image.getMetadata()).operatingSystem((OperatingSystem)this.imageToOs.apply((Object)image)).description(image.getName()).location(location).status(this.toPortableImageStatus.get((Object)image.getStatus())).build();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).toString();
    }
}

