/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute.predicates;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.compute.domain.Image;
import org.jclouds.logging.Logger;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.domain.zonescoped.ImageInZone;
import org.jclouds.openstack.nova.v2_0.domain.zonescoped.ZoneAndId;
import org.jclouds.predicates.PredicateWithResult;

public final class GetImageWhenImageInZoneHasActiveStatusPredicateWithResult
implements PredicateWithResult<ZoneAndId, Image> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private org.jclouds.openstack.nova.v2_0.domain.Image result;
    private ZoneAndId resultZoneAndId;
    private RuntimeException lastFailure;
    private Function<ImageInZone, Image> imageInZoneToImage;
    private NovaApi api;

    @Inject
    public GetImageWhenImageInZoneHasActiveStatusPredicateWithResult(Function<ImageInZone, Image> imageInZoneToImage, NovaApi api) {
        this.imageInZoneToImage = imageInZoneToImage;
        this.api = api;
    }

    public boolean apply(ZoneAndId input) {
        this.result = (org.jclouds.openstack.nova.v2_0.domain.Image)((Object)Preconditions.checkNotNull((Object)((Object)this.findImage(ZoneAndId.fromZoneAndId(input.getZone(), input.getId())))));
        this.resultZoneAndId = input;
        switch (this.result.getStatus()) {
            case ACTIVE: {
                this.logger.info("<< Image %s is available for use. %s", new Object[]{input.getId(), this.result});
                return true;
            }
            case UNRECOGNIZED: 
            case SAVING: {
                this.logger.debug("<< Image %s is not available yet. %s", new Object[]{input.getId(), this.result});
                return false;
            }
        }
        this.lastFailure = new IllegalStateException("Image " + input.getId() + " was not created. " + (Object)((Object)this.result));
        throw this.lastFailure;
    }

    public Image getResult() {
        return (Image)this.imageInZoneToImage.apply((Object)new ImageInZone(this.result, this.resultZoneAndId.getZone()));
    }

    public Throwable getLastFailure() {
        return this.lastFailure;
    }

    public org.jclouds.openstack.nova.v2_0.domain.Image findImage(final ZoneAndId zoneAndId) {
        return (org.jclouds.openstack.nova.v2_0.domain.Image)((Object)this.api.getImageApiForZone(zoneAndId.getZone()).listInDetail().concat().firstMatch((Predicate)new Predicate<org.jclouds.openstack.nova.v2_0.domain.Image>(){

            public boolean apply(org.jclouds.openstack.nova.v2_0.domain.Image input) {
                return input.getId().equals(zoneAndId.getId());
            }
        }).orNull());
    }
}

