/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.ec2.config;

import com.google.common.base.Objects;
import com.google.inject.AbstractModule;
import java.util.Date;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.date.DateService;
import org.jclouds.date.internal.SimpleDateFormatDateService;

public class NovaEC2ParserModule
extends AbstractModule {
    protected void configure() {
        this.bind(DateService.class).to(Iso8601WithDashesTreatedAsNullDateService.class);
    }

    @Singleton
    public static class Iso8601WithDashesTreatedAsNullDateService
    implements DateService {
        DateService delegate;

        @Inject
        public Iso8601WithDashesTreatedAsNullDateService(SimpleDateFormatDateService service) {
            this.delegate = service;
        }

        public Date fromSeconds(long seconds) {
            return this.delegate.fromSeconds(seconds);
        }

        public String cDateFormat(Date date) {
            return this.delegate.cDateFormat(date);
        }

        public String cDateFormat() {
            return this.delegate.cDateFormat();
        }

        public Date cDateParse(String toParse) {
            return this.delegate.cDateParse(toParse);
        }

        public String rfc822DateFormat(Date date) {
            return this.delegate.rfc822DateFormat(date);
        }

        public String rfc822DateFormat() {
            return this.delegate.rfc822DateFormat();
        }

        public Date rfc822DateParse(String toParse) {
            return this.delegate.rfc822DateParse(toParse);
        }

        public String iso8601SecondsDateFormat(Date dateTime) {
            return this.delegate.iso8601SecondsDateFormat(dateTime);
        }

        public String iso8601SecondsDateFormat() {
            return this.delegate.iso8601SecondsDateFormat();
        }

        public String iso8601DateFormat(Date date) {
            return this.delegate.iso8601DateFormat(date);
        }

        public String iso8601DateFormat() {
            return this.delegate.iso8601DateFormat();
        }

        public Date iso8601DateParse(String toParse) {
            if (Objects.equal((Object)"-", (Object)toParse)) {
                return null;
            }
            return this.delegate.iso8601DateParse(toParse);
        }

        public Date iso8601SecondsDateParse(String toParse) {
            if (Objects.equal((Object)"-", (Object)toParse)) {
                return null;
            }
            return this.delegate.iso8601SecondsDateParse(toParse);
        }

        public String rfc1123DateFormat(Date date) {
            return this.delegate.rfc1123DateFormat(date);
        }

        public String rfc1123DateFormat() {
            return this.delegate.rfc1123DateFormat();
        }

        public Date rfc1123DateParse(String toParse) {
            return this.delegate.rfc1123DateParse(toParse);
        }
    }
}

