/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudidentity.v2_0.functions;

import com.google.common.base.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.openstack.keystone.v2_0.config.CredentialType;
import org.jclouds.openstack.keystone.v2_0.domain.Access;
import org.jclouds.openstack.keystone.v2_0.functions.internal.BaseAuthenticator;
import org.jclouds.rackspace.cloudidentity.v2_0.CloudIdentityAuthenticationClient;
import org.jclouds.rackspace.cloudidentity.v2_0.domain.ApiKeyCredentials;

@CredentialType(value="RAX-KSKEY:apiKeyCredentials")
@Singleton
public class AuthenticateApiKeyCredentials
extends BaseAuthenticator<ApiKeyCredentials> {
    protected final CloudIdentityAuthenticationClient client;

    @Inject
    public AuthenticateApiKeyCredentials(CloudIdentityAuthenticationClient client) {
        this.client = client;
    }

    protected Access authenticateWithTenantName(Optional<String> tenantId, ApiKeyCredentials apiKeyCredentials) {
        return this.client.authenticateWithTenantNameAndCredentials((String)tenantId.orNull(), apiKeyCredentials);
    }

    protected Access authenticateWithTenantId(Optional<String> tenantId, ApiKeyCredentials apiKeyCredentials) {
        return this.client.authenticateWithTenantIdAndCredentials((String)tenantId.orNull(), apiKeyCredentials);
    }

    public ApiKeyCredentials createCredentials(String identity, String credential) {
        return ApiKeyCredentials.createWithUsernameAndApiKey(identity, credential);
    }

    public String toString() {
        return "authenticateApiKeyCredentials()";
    }
}

