/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudidentity.v2_0;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import java.net.URI;
import java.util.Properties;
import java.util.Set;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.openstack.keystone.v2_0.KeystoneApiMetadata;
import org.jclouds.openstack.keystone.v2_0.KeystoneAsyncClient;
import org.jclouds.openstack.keystone.v2_0.KeystoneClient;
import org.jclouds.openstack.keystone.v2_0.config.KeystoneParserModule;
import org.jclouds.openstack.keystone.v2_0.config.KeystoneRestClientModule;
import org.jclouds.rackspace.cloudidentity.v2_0.config.CloudIdentityAuthenticationModule;
import org.jclouds.rest.RestContext;

public class CloudIdentityApiMetadata
extends KeystoneApiMetadata {
    private static final long serialVersionUID = -1572520638079261710L;
    public static final TypeToken<RestContext<KeystoneClient, KeystoneAsyncClient>> CONTEXT_TOKEN = new TypeToken<RestContext<KeystoneClient, KeystoneAsyncClient>>(){
        private static final long serialVersionUID = -5070937833892503232L;
    };

    private static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return CloudIdentityApiMetadata.builder().fromApiMetadata((ApiMetadata)this);
    }

    public CloudIdentityApiMetadata() {
        this(CloudIdentityApiMetadata.builder());
    }

    protected CloudIdentityApiMetadata(Builder builder) {
        super((KeystoneApiMetadata.Builder)builder);
    }

    public static Properties defaultProperties() {
        Properties properties = KeystoneApiMetadata.defaultProperties();
        properties.setProperty("jclouds.keystone.credential-type", "RAX-KSKEY:apiKeyCredentials");
        return properties;
    }

    public static class Builder
    extends KeystoneApiMetadata.Builder {
        protected Builder() {
            super(KeystoneClient.class, KeystoneAsyncClient.class);
            this.id("rackspace-cloudidentity").name("Rackspace Cloud Identity Service").defaultEndpoint("https://identity.api.rackspacecloud.com").identityName("username").credentialName("API Key").defaultProperties(CloudIdentityApiMetadata.defaultProperties()).context(CONTEXT_TOKEN).documentation(URI.create("http://docs.rackspace.com/auth/api/v2.0/auth-client-devguide/")).defaultModules((Set)ImmutableSet.builder().add(CloudIdentityAuthenticationModule.class).add(KeystoneRestClientModule.KeystoneAdminURLModule.class).add(KeystoneParserModule.class).add(KeystoneRestClientModule.class).build());
        }

        public CloudIdentityApiMetadata build() {
            return new CloudIdentityApiMetadata(this);
        }

        public Builder fromApiMetadata(ApiMetadata in) {
            super.fromApiMetadata(in);
            return this;
        }
    }
}

