/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudidentity.v2_0.config;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Scopes;
import java.util.Map;
import org.jclouds.domain.Credentials;
import org.jclouds.openstack.keystone.v2_0.AuthenticationAsyncClient;
import org.jclouds.openstack.keystone.v2_0.AuthenticationClient;
import org.jclouds.openstack.keystone.v2_0.config.CredentialTypes;
import org.jclouds.openstack.keystone.v2_0.config.KeystoneAuthenticationModule;
import org.jclouds.openstack.keystone.v2_0.domain.Access;
import org.jclouds.openstack.keystone.v2_0.functions.AuthenticatePasswordCredentials;
import org.jclouds.rackspace.cloudidentity.v2_0.CloudIdentityAuthenticationAsyncClient;
import org.jclouds.rackspace.cloudidentity.v2_0.CloudIdentityAuthenticationClient;
import org.jclouds.rackspace.cloudidentity.v2_0.functions.AuthenticateApiKeyCredentials;
import org.jclouds.rest.config.BinderUtils;

public class CloudIdentityAuthenticationModule
extends KeystoneAuthenticationModule {
    protected void bindAuthenticationClient() {
        BinderUtils.bindClientAndAsyncClient((Binder)this.binder(), CloudIdentityAuthenticationClient.class, CloudIdentityAuthenticationAsyncClient.class);
        this.bind(AuthenticationClient.class).to(CloudIdentityAuthenticationClient.class).in(Scopes.SINGLETON);
        this.bind(AuthenticationAsyncClient.class).to(CloudIdentityAuthenticationAsyncClient.class).in(Scopes.SINGLETON);
    }

    protected Map<String, Function<Credentials, Access>> authenticationMethods(Injector i) {
        ImmutableSet.Builder fns = ImmutableSet.builder();
        fns.add(i.getInstance(AuthenticatePasswordCredentials.class));
        fns.add(i.getInstance(AuthenticateApiKeyCredentials.class));
        return CredentialTypes.indexByCredentialType((Iterable)fns.build());
    }
}

