/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.binders;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.jamesmurty.utils.XMLBuilder;
import java.util.Map;
import java.util.Properties;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.binders.BindToStringPayload;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.vcloud.options.CaptureVAppOptions;

@Singleton
public class BindCaptureVAppParamsToXmlPayload
implements MapBinder {
    protected final String ns;
    protected final String schema;
    private final BindToStringPayload stringBinder;

    @Inject
    public BindCaptureVAppParamsToXmlPayload(BindToStringPayload stringBinder, @Named(value="jclouds.vcloud.xml.ns") String ns, @Named(value="jclouds.vcloud.xml.schema") String schema) {
        this.ns = ns;
        this.schema = schema;
        this.stringBinder = stringBinder;
    }

    public <R extends HttpRequest> R bindToRequest(R request, Map<String, String> postParams) {
        Preconditions.checkArgument((boolean)(Preconditions.checkNotNull(request, (Object)"request") instanceof GeneratedHttpRequest), (Object)"this binder is only valid for GeneratedHttpRequests!");
        GeneratedHttpRequest gRequest = (GeneratedHttpRequest)request;
        Preconditions.checkState((gRequest.getArgs() != null ? 1 : 0) != 0, (Object)"args should be initialized at this point");
        String templateName = (String)Preconditions.checkNotNull((Object)postParams.remove("templateName"), (Object)"templateName");
        String vApp = (String)Preconditions.checkNotNull((Object)postParams.remove("vApp"), (Object)"vApp");
        CaptureVAppOptions options = this.findOptionsInArgsOrNull(gRequest);
        if (options == null) {
            options = new CaptureVAppOptions();
        }
        try {
            return (R)this.stringBinder.bindToRequest(request, (Object)this.generateXml(templateName, vApp, options));
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (FactoryConfigurationError e) {
            throw new RuntimeException(e);
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    protected String generateXml(String templateName, String vApp, CaptureVAppOptions options) throws ParserConfigurationException, FactoryConfigurationError, TransformerException {
        XMLBuilder rootBuilder = this.buildRoot(templateName);
        if (options.getDescription() != null) {
            rootBuilder.e("Description").text(options.getDescription());
        }
        rootBuilder.e("Source").a("href", vApp).a("type", "application/vnd.vmware.vcloud.vApp+xml");
        Properties outputProperties = new Properties();
        outputProperties.put("omit-xml-declaration", "yes");
        return rootBuilder.asString(outputProperties);
    }

    protected XMLBuilder buildRoot(String name) throws ParserConfigurationException, FactoryConfigurationError {
        XMLBuilder rootBuilder = XMLBuilder.create((String)"CaptureVAppParams").a("name", name).a("xmlns", this.ns).a("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance").a("xsi:schemaLocation", this.ns + " " + this.schema);
        return rootBuilder;
    }

    protected CaptureVAppOptions findOptionsInArgsOrNull(GeneratedHttpRequest<?> gRequest) {
        for (Object arg : gRequest.getArgs()) {
            if (arg instanceof CaptureVAppOptions) {
                return (CaptureVAppOptions)arg;
            }
            if (!(arg instanceof CaptureVAppOptions[])) continue;
            CaptureVAppOptions[] options = (CaptureVAppOptions[])arg;
            return options.length > 0 ? options[0] : null;
        }
        return null;
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        throw new IllegalStateException("CaptureVAppParams is needs parameters");
    }

    protected String ifNullDefaultTo(String value, String defaultValue) {
        return value != null ? value : (String)Preconditions.checkNotNull((Object)defaultValue, (Object)"defaultValue");
    }
}

