/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.compute.options;

import java.util.Map;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.io.Payload;
import org.jclouds.util.Preconditions2;
import org.jclouds.vcloud.domain.network.IpAddressAllocationMode;

public class VCloudTemplateOptions
extends TemplateOptions
implements Cloneable {
    private String description = null;
    private String customizationScript = null;
    private IpAddressAllocationMode ipAddressAllocationMode = null;
    public static final VCloudTemplateOptions NONE = new VCloudTemplateOptions();

    public VCloudTemplateOptions clone() {
        VCloudTemplateOptions options = new VCloudTemplateOptions();
        this.copyTo(options);
        return options;
    }

    public void copyTo(TemplateOptions to) {
        super.copyTo(to);
        if (to instanceof VCloudTemplateOptions) {
            VCloudTemplateOptions eTo = (VCloudTemplateOptions)VCloudTemplateOptions.class.cast(to);
            if (this.getCustomizationScript() != null) {
                eTo.customizationScript(this.getCustomizationScript());
            }
            if (this.getDescription() != null) {
                eTo.description(this.getDescription());
            }
            if (this.getIpAddressAllocationMode() != null) {
                eTo.ipAddressAllocationMode(this.getIpAddressAllocationMode());
            }
        }
    }

    public VCloudTemplateOptions description(String description) {
        this.description = description;
        return this;
    }

    public VCloudTemplateOptions customizationScript(String customizationScript) {
        Preconditions2.checkNotEmpty((String)customizationScript, (String)"customizationScript must be non-empty");
        this.customizationScript = customizationScript;
        return this;
    }

    public VCloudTemplateOptions ipAddressAllocationMode(IpAddressAllocationMode ipAddressAllocationMode) {
        this.ipAddressAllocationMode = ipAddressAllocationMode;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCustomizationScript() {
        return this.customizationScript;
    }

    public IpAddressAllocationMode getIpAddressAllocationMode() {
        return this.ipAddressAllocationMode;
    }

    public VCloudTemplateOptions blockOnPort(int port, int seconds) {
        return (VCloudTemplateOptions)VCloudTemplateOptions.class.cast(super.blockOnPort(port, seconds));
    }

    public VCloudTemplateOptions inboundPorts(int ... ports) {
        return (VCloudTemplateOptions)VCloudTemplateOptions.class.cast(super.inboundPorts(ports));
    }

    public VCloudTemplateOptions authorizePublicKey(String publicKey) {
        return (VCloudTemplateOptions)VCloudTemplateOptions.class.cast(super.authorizePublicKey(publicKey));
    }

    public VCloudTemplateOptions installPrivateKey(String privateKey) {
        return (VCloudTemplateOptions)VCloudTemplateOptions.class.cast(super.installPrivateKey(privateKey));
    }

    @Deprecated
    public VCloudTemplateOptions runScript(Payload script) {
        return (VCloudTemplateOptions)VCloudTemplateOptions.class.cast(super.runScript(script));
    }

    public VCloudTemplateOptions userMetadata(Map<String, String> userMetadata) {
        return (VCloudTemplateOptions)VCloudTemplateOptions.class.cast(super.userMetadata(userMetadata));
    }

    public VCloudTemplateOptions userMetadata(String key, String value) {
        return (VCloudTemplateOptions)VCloudTemplateOptions.class.cast(super.userMetadata(key, value));
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.customizationScript == null ? 0 : this.customizationScript.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.ipAddressAllocationMode == null ? 0 : this.ipAddressAllocationMode.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VCloudTemplateOptions other = (VCloudTemplateOptions)obj;
        if (this.customizationScript == null ? other.customizationScript != null : !this.customizationScript.equals(other.customizationScript)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        return this.ipAddressAllocationMode == other.ipAddressAllocationMode;
    }

    public String toString() {
        return "[customizationScript=" + (this.customizationScript != null) + ", description=" + this.description + ", ipAddressAllocationMode=" + (Object)((Object)this.ipAddressAllocationMode) + ", inboundPorts=" + this.inboundPorts + ", privateKey=" + (this.privateKey != null) + ", publicKey=" + (this.publicKey != null) + ", runScript=" + (this.script != null) + ", port:seconds=" + this.port + ":" + this.seconds + ", userMetadata: " + this.userMetadata + "]";
    }

    public static class Builder {
        public static VCloudTemplateOptions description(String description) {
            VCloudTemplateOptions options = new VCloudTemplateOptions();
            return (VCloudTemplateOptions)VCloudTemplateOptions.class.cast(options.description(description));
        }

        public static VCloudTemplateOptions customizationScript(String customizationScript) {
            VCloudTemplateOptions options = new VCloudTemplateOptions();
            return (VCloudTemplateOptions)VCloudTemplateOptions.class.cast(options.customizationScript(customizationScript));
        }

        public static VCloudTemplateOptions ipAddressAllocationMode(IpAddressAllocationMode ipAddressAllocationMode) {
            VCloudTemplateOptions options = new VCloudTemplateOptions();
            return (VCloudTemplateOptions)VCloudTemplateOptions.class.cast(options.ipAddressAllocationMode(ipAddressAllocationMode));
        }

        public static VCloudTemplateOptions inboundPorts(int ... ports) {
            VCloudTemplateOptions options = new VCloudTemplateOptions();
            return (VCloudTemplateOptions)VCloudTemplateOptions.class.cast(options.inboundPorts(ports));
        }

        public static VCloudTemplateOptions blockOnPort(int port, int seconds) {
            VCloudTemplateOptions options = new VCloudTemplateOptions();
            return (VCloudTemplateOptions)VCloudTemplateOptions.class.cast(options.blockOnPort(port, seconds));
        }

        public static VCloudTemplateOptions runScript(Payload script) {
            VCloudTemplateOptions options = new VCloudTemplateOptions();
            return (VCloudTemplateOptions)VCloudTemplateOptions.class.cast(options.runScript(script));
        }

        public static VCloudTemplateOptions userMetadata(Map<String, String> userMetadata) {
            VCloudTemplateOptions options = new VCloudTemplateOptions();
            return (VCloudTemplateOptions)VCloudTemplateOptions.class.cast(options.userMetadata((Map)userMetadata));
        }

        public static VCloudTemplateOptions userMetadata(String key, String value) {
            VCloudTemplateOptions options = new VCloudTemplateOptions();
            return (VCloudTemplateOptions)VCloudTemplateOptions.class.cast(options.userMetadata(key, value));
        }
    }
}

