/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.predicates;

import com.google.common.base.Predicate;
import com.google.inject.Inject;
import java.net.URI;
import javax.annotation.Resource;
import javax.inject.Singleton;
import org.jclouds.logging.Logger;
import org.jclouds.vcloud.TaskInErrorStateException;
import org.jclouds.vcloud.VCloudClient;
import org.jclouds.vcloud.domain.Task;
import org.jclouds.vcloud.domain.TaskStatus;

@Singleton
public class TaskSuccess
implements Predicate<URI> {
    private final VCloudClient client;
    @Resource
    protected Logger logger = Logger.NULL;

    @Inject
    public TaskSuccess(VCloudClient client) {
        this.client = client;
    }

    public boolean apply(URI taskId) {
        this.logger.trace("looking for status on task %s", new Object[]{taskId});
        Task task = this.client.getTaskClient().getTask(taskId);
        if (task == null) {
            return false;
        }
        this.logger.trace("%s: looking for status %s: currently: %s", new Object[]{task, TaskStatus.SUCCESS, task.getStatus()});
        if (task.getStatus() == TaskStatus.ERROR) {
            throw new TaskInErrorStateException(task);
        }
        return task.getStatus() == TaskStatus.SUCCESS;
    }
}

