/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.domain.network;

import org.jclouds.javax.annotation.Nullable;
import org.jclouds.vcloud.domain.network.IpRange;

public class DhcpService {
    private final boolean enabled;
    @Nullable
    private final Integer defaultLeaseTime;
    @Nullable
    private final Integer maxLeaseTime;
    @Nullable
    private final IpRange ipRange;

    public DhcpService(boolean enabled, @Nullable Integer defaultLeaseTime, @Nullable Integer maxLeaseTime, @Nullable IpRange ipRange) {
        this.enabled = enabled;
        this.defaultLeaseTime = defaultLeaseTime;
        this.maxLeaseTime = maxLeaseTime;
        this.ipRange = ipRange;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Nullable
    public Integer getDefaultLeaseTime() {
        return this.defaultLeaseTime;
    }

    @Nullable
    public Integer getMaxLeaseTime() {
        return this.maxLeaseTime;
    }

    @Nullable
    public IpRange getIpRange() {
        return this.ipRange;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.defaultLeaseTime == null ? 0 : this.defaultLeaseTime.hashCode());
        result = 31 * result + (this.enabled ? 1231 : 1237);
        result = 31 * result + (this.ipRange == null ? 0 : this.ipRange.hashCode());
        result = 31 * result + (this.maxLeaseTime == null ? 0 : this.maxLeaseTime.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DhcpService other = (DhcpService)obj;
        if (this.defaultLeaseTime == null ? other.defaultLeaseTime != null : !this.defaultLeaseTime.equals(other.defaultLeaseTime)) {
            return false;
        }
        if (this.enabled != other.enabled) {
            return false;
        }
        if (this.ipRange == null ? other.ipRange != null : !this.ipRange.equals(other.ipRange)) {
            return false;
        }
        return !(this.maxLeaseTime == null ? other.maxLeaseTime != null : !this.maxLeaseTime.equals(other.maxLeaseTime));
    }

    public String toString() {
        return "[defaultLeaseTime=" + this.defaultLeaseTime + ", enabled=" + this.enabled + ", ipRange=" + this.ipRange + ", maxLeaseTime=" + this.maxLeaseTime + "]";
    }
}

