/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.endpoints.Catalog;
import org.jclouds.vcloud.endpoints.Org;

@Singleton
public class OrgNameCatalogNameItemNameToEndpoint
implements Function<Object, URI> {
    private final Supplier<Map<String, Map<String, org.jclouds.vcloud.domain.Catalog>>> orgCatalogMap;
    private final Supplier<ReferenceType> defaultOrg;
    private final Supplier<ReferenceType> defaultCatalog;

    @Inject
    public OrgNameCatalogNameItemNameToEndpoint(Supplier<Map<String, Map<String, org.jclouds.vcloud.domain.Catalog>>> orgCatalogMap, @Org Supplier<ReferenceType> defaultOrg, @Catalog Supplier<ReferenceType> defaultCatalog) {
        this.orgCatalogMap = orgCatalogMap;
        this.defaultOrg = defaultOrg;
        this.defaultCatalog = defaultCatalog;
    }

    public URI apply(Object from) {
        Iterable orgCatalog = (Iterable)Preconditions.checkNotNull((Object)from, (Object)"args");
        Object org = Iterables.get((Iterable)orgCatalog, (int)0);
        Object catalog = Iterables.get((Iterable)orgCatalog, (int)1);
        Object catalogItem = Iterables.get((Iterable)orgCatalog, (int)2);
        if (org == null) {
            org = ((ReferenceType)this.defaultOrg.get()).getName();
        }
        if (catalog == null) {
            catalog = ((ReferenceType)this.defaultCatalog.get()).getName();
        }
        try {
            Map catalogs = (Map)Preconditions.checkNotNull(((Map)this.orgCatalogMap.get()).get(org));
            return ((ReferenceType)((org.jclouds.vcloud.domain.Catalog)catalogs.get(catalog)).get(catalogItem)).getHref();
        }
        catch (NullPointerException e) {
            throw new NoSuchElementException(org + "/" + catalog + "/" + catalogItem + " not found in " + this.orgCatalogMap.get());
        }
    }
}

