/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.domain.network;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Set;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.vcloud.domain.network.IpRange;

public class IpScope {
    private final boolean inherited;
    @Nullable
    private final String gateway;
    @Nullable
    private final String netmask;
    @Nullable
    private final String dns1;
    @Nullable
    private final String dns2;
    @Nullable
    private final String dnsSuffix;
    private final Set<IpRange> ipRanges = Sets.newLinkedHashSet();
    private final Set<String> allocatedIpAddresses = Sets.newLinkedHashSet();

    public IpScope(boolean inherited, @Nullable String gateway, @Nullable String netmask, @Nullable String dns1, @Nullable String dns2, @Nullable String dnsSuffix, Iterable<IpRange> ipRanges, Iterable<String> allocatedIpAddresses) {
        this.inherited = inherited;
        this.gateway = gateway;
        this.netmask = netmask;
        this.dns1 = dns1;
        this.dns2 = dns2;
        this.dnsSuffix = dnsSuffix;
        Iterables.addAll(this.ipRanges, (Iterable)((Iterable)Preconditions.checkNotNull(ipRanges, (Object)"ipRanges")));
        Iterables.addAll(this.allocatedIpAddresses, (Iterable)((Iterable)Preconditions.checkNotNull(allocatedIpAddresses, (Object)"allocatedIpAddresses")));
    }

    public boolean isInherited() {
        return this.inherited;
    }

    @Nullable
    public String getGateway() {
        return this.gateway;
    }

    @Nullable
    public String getNetmask() {
        return this.netmask;
    }

    @Nullable
    public String getDns1() {
        return this.dns1;
    }

    @Nullable
    public String getDns2() {
        return this.dns2;
    }

    @Nullable
    public String getDnsSuffix() {
        return this.dnsSuffix;
    }

    public Set<IpRange> getIpRanges() {
        return this.ipRanges;
    }

    public Set<String> getAllocatedIpAddresses() {
        return this.allocatedIpAddresses;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.allocatedIpAddresses == null ? 0 : ((Object)this.allocatedIpAddresses).hashCode());
        result = 31 * result + (this.dns1 == null ? 0 : this.dns1.hashCode());
        result = 31 * result + (this.dns2 == null ? 0 : this.dns2.hashCode());
        result = 31 * result + (this.dnsSuffix == null ? 0 : this.dnsSuffix.hashCode());
        result = 31 * result + (this.gateway == null ? 0 : this.gateway.hashCode());
        result = 31 * result + (this.inherited ? 1231 : 1237);
        result = 31 * result + (this.ipRanges == null ? 0 : ((Object)this.ipRanges).hashCode());
        result = 31 * result + (this.netmask == null ? 0 : this.netmask.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IpScope other = (IpScope)obj;
        if (this.allocatedIpAddresses == null ? other.allocatedIpAddresses != null : !((Object)this.allocatedIpAddresses).equals(other.allocatedIpAddresses)) {
            return false;
        }
        if (this.dns1 == null ? other.dns1 != null : !this.dns1.equals(other.dns1)) {
            return false;
        }
        if (this.dns2 == null ? other.dns2 != null : !this.dns2.equals(other.dns2)) {
            return false;
        }
        if (this.dnsSuffix == null ? other.dnsSuffix != null : !this.dnsSuffix.equals(other.dnsSuffix)) {
            return false;
        }
        if (this.gateway == null ? other.gateway != null : !this.gateway.equals(other.gateway)) {
            return false;
        }
        if (this.inherited != other.inherited) {
            return false;
        }
        if (this.ipRanges == null ? other.ipRanges != null : !((Object)this.ipRanges).equals(other.ipRanges)) {
            return false;
        }
        return !(this.netmask == null ? other.netmask != null : !this.netmask.equals(other.netmask));
    }

    public String toString() {
        return "[allocatedIpAddresses=" + this.allocatedIpAddresses + ", dns1=" + this.dns1 + ", dns2=" + this.dns2 + ", dnsSuffix=" + this.dnsSuffix + ", gateway=" + this.gateway + ", inherited=" + this.inherited + ", ipRanges=" + this.ipRanges + ", netmask=" + this.netmask + "]";
    }
}

