/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.domain.network.firewall;

import com.google.common.base.Preconditions;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.vcloud.domain.network.firewall.FirewallPolicy;
import org.jclouds.vcloud.domain.network.firewall.FirewallProtocols;

public class FirewallRule {
    private final boolean enabled;
    @Nullable
    private final String description;
    @Nullable
    private final FirewallPolicy policy;
    @Nullable
    private final FirewallProtocols protocols;
    private final int port;
    private final String destinationIp;

    public FirewallRule(boolean enabled, @Nullable String description, @Nullable FirewallPolicy policy, @Nullable FirewallProtocols protocols, int port, String destinationIp) {
        this.enabled = enabled;
        this.description = description;
        this.policy = policy;
        this.protocols = protocols;
        this.port = port;
        this.destinationIp = (String)Preconditions.checkNotNull((Object)destinationIp, (Object)"destinationIp");
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public FirewallPolicy getPolicy() {
        return this.policy;
    }

    @Nullable
    public FirewallProtocols getProtocols() {
        return this.protocols;
    }

    public int getPort() {
        return this.port;
    }

    public String getDestinationIp() {
        return this.destinationIp;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.destinationIp == null ? 0 : this.destinationIp.hashCode());
        result = 31 * result + (this.enabled ? 1231 : 1237);
        result = 31 * result + (this.policy == null ? 0 : this.policy.hashCode());
        result = 31 * result + this.port;
        result = 31 * result + (this.protocols == null ? 0 : this.protocols.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FirewallRule other = (FirewallRule)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.destinationIp == null ? other.destinationIp != null : !this.destinationIp.equals(other.destinationIp)) {
            return false;
        }
        if (this.enabled != other.enabled) {
            return false;
        }
        if (this.policy == null ? other.policy != null : !this.policy.equals((Object)other.policy)) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        return !(this.protocols == null ? other.protocols != null : !this.protocols.equals(other.protocols));
    }

    public String toString() {
        return "[description=" + this.description + ", destinationIp=" + this.destinationIp + ", enabled=" + this.enabled + ", policy=" + (Object)((Object)this.policy) + ", port=" + this.port + ", protocols=" + this.protocols + "]";
    }
}

