/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.compute.strategy;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.domain.Template;
import org.jclouds.domain.Location;
import org.jclouds.logging.Logger;
import org.jclouds.ovf.Envelope;
import org.jclouds.vcloud.TaskInErrorStateException;
import org.jclouds.vcloud.TaskStillRunningException;
import org.jclouds.vcloud.VCloudClient;
import org.jclouds.vcloud.compute.strategy.InstantiateVAppTemplateWithGroupEncodedIntoNameThenCustomizeDeployAndPowerOn;
import org.jclouds.vcloud.domain.Org;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.Status;
import org.jclouds.vcloud.domain.Task;
import org.jclouds.vcloud.domain.VApp;
import org.jclouds.vcloud.domain.VAppTemplate;
import org.jclouds.vcloud.suppliers.VAppTemplatesSupplier;

@Singleton
public class VCloudComputeServiceAdapter
implements ComputeServiceAdapter<VApp, VAppTemplate, VAppTemplate, Location> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final VCloudClient client;
    protected final Predicate<URI> successTester;
    protected final InstantiateVAppTemplateWithGroupEncodedIntoNameThenCustomizeDeployAndPowerOn booter;
    protected final Supplier<Map<String, Org>> nameToOrg;
    protected final Supplier<Set<VAppTemplate>> templates;
    protected final Function<VAppTemplate, Envelope> templateToEnvelope;

    @Inject
    protected VCloudComputeServiceAdapter(VCloudClient client, Predicate<URI> successTester, InstantiateVAppTemplateWithGroupEncodedIntoNameThenCustomizeDeployAndPowerOn booter, Supplier<Map<String, Org>> nameToOrg, VAppTemplatesSupplier templates, Function<VAppTemplate, Envelope> templateToEnvelope) {
        this.client = (VCloudClient)Preconditions.checkNotNull((Object)client, (Object)"client");
        this.successTester = (Predicate)Preconditions.checkNotNull(successTester, (Object)"successTester");
        this.booter = (InstantiateVAppTemplateWithGroupEncodedIntoNameThenCustomizeDeployAndPowerOn)Preconditions.checkNotNull((Object)booter, (Object)"booter");
        this.nameToOrg = (Supplier)Preconditions.checkNotNull(nameToOrg, (Object)"nameToOrg");
        this.templates = (Supplier)Preconditions.checkNotNull((Object)templates, (Object)"templates");
        this.templateToEnvelope = (Function)Preconditions.checkNotNull(templateToEnvelope, (Object)"templateToEnvelope");
    }

    public ComputeServiceAdapter.NodeAndInitialCredentials<VApp> createNodeWithGroupEncodedIntoName(String group, String name, Template template) {
        return this.booter.createNodeWithGroupEncodedIntoName(group, name, template);
    }

    public Iterable<VAppTemplate> listHardwareProfiles() {
        return this.supportedTemplates();
    }

    private Iterable<VAppTemplate> supportedTemplates() {
        return Iterables.filter((Iterable)((Iterable)this.templates.get()), (Predicate)new Predicate<VAppTemplate>(){

            public boolean apply(VAppTemplate from) {
                try {
                    VCloudComputeServiceAdapter.this.templateToEnvelope.apply((Object)from);
                }
                catch (IllegalArgumentException e) {
                    VCloudComputeServiceAdapter.this.logger.warn("Unsupported: " + e.getMessage(), new Object[0]);
                    return false;
                }
                return true;
            }
        });
    }

    public Iterable<VAppTemplate> listImages() {
        return this.supportedTemplates();
    }

    public Iterable<VApp> listNodes() {
        ImmutableSet.Builder nodes = ImmutableSet.builder();
        for (Org org : ((Map)this.nameToOrg.get()).values()) {
            for (ReferenceType vdc : org.getVDCs().values()) {
                for (ReferenceType resource : this.client.getVDCClient().getVDC(vdc.getHref()).getResourceEntities().values()) {
                    if (!resource.getType().equals("application/vnd.vmware.vcloud.vApp+xml")) continue;
                    this.addVAppToSetRetryingIfNotYetPresent((ImmutableSet.Builder<VApp>)nodes, vdc, resource);
                }
            }
        }
        return nodes.build();
    }

    @VisibleForTesting
    void addVAppToSetRetryingIfNotYetPresent(ImmutableSet.Builder<VApp> nodes, ReferenceType vdc, ReferenceType resource) {
        VApp node = null;
        int i = 0;
        while (node == null && i++ < 3) {
            try {
                node = this.client.getVAppClient().getVApp(resource.getHref());
                nodes.add((Object)node);
            }
            catch (NullPointerException e) {
                this.logger.warn("vApp %s not yet present in vdc %s", new Object[]{resource.getName(), vdc.getName()});
            }
        }
    }

    public Iterable<Location> listLocations() {
        return ImmutableSet.of();
    }

    public VApp getNode(String in) {
        URI id = URI.create(in);
        return this.client.getVAppClient().getVApp(id);
    }

    public VAppTemplate getImage(String in) {
        URI id = URI.create(in);
        return this.client.getVAppTemplateClient().getVAppTemplate(id);
    }

    public void destroyNode(String id) {
        URI vappId = URI.create((String)Preconditions.checkNotNull((Object)id, (Object)"node.id"));
        VApp vApp = this.cancelAnyRunningTasks(vappId);
        if (vApp.getStatus() != Status.OFF) {
            this.logger.debug(">> powering off VApp vApp(%s), current status: %s", new Object[]{vApp.getName(), vApp.getStatus()});
            try {
                this.waitForTask(this.client.getVAppClient().powerOffVApp(vApp.getHref()));
                vApp = this.client.getVAppClient().getVApp(vApp.getHref());
                this.logger.debug("<< %s vApp(%s)", new Object[]{vApp.getStatus(), vApp.getName()});
            }
            catch (IllegalStateException e) {
                this.logger.warn((Throwable)e, "<< %s vApp(%s)", new Object[]{vApp.getStatus(), vApp.getName()});
            }
            this.logger.debug(">> undeploying vApp(%s), current status: %s", new Object[]{vApp.getName(), vApp.getStatus()});
            try {
                this.waitForTask(this.client.getVAppClient().undeployVApp(vApp.getHref()));
                vApp = this.client.getVAppClient().getVApp(vApp.getHref());
                this.logger.debug("<< %s vApp(%s)", new Object[]{vApp.getStatus(), vApp.getName()});
            }
            catch (IllegalStateException e) {
                this.logger.warn((Throwable)e, "<< %s vApp(%s)", new Object[]{vApp.getStatus(), vApp.getName()});
            }
        }
        this.logger.debug(">> deleting vApp(%s)", new Object[]{vApp.getHref()});
        this.waitForTask(this.client.getVAppClient().deleteVApp(vApp.getHref()));
        this.logger.debug("<< deleted vApp(%s)", new Object[]{vApp.getHref()});
    }

    VApp waitForPendingTasksToComplete(URI vappId) {
        VApp vApp = this.client.getVAppClient().getVApp(vappId);
        if (vApp.getTasks().size() == 0) {
            return vApp;
        }
        for (Task task : vApp.getTasks()) {
            this.waitForTask(task);
        }
        return this.client.getVAppClient().getVApp(vappId);
    }

    VApp cancelAnyRunningTasks(URI vappId) {
        VApp vApp = this.client.getVAppClient().getVApp(vappId);
        if (vApp.getTasks().size() == 0) {
            return vApp;
        }
        for (Task task : vApp.getTasks()) {
            try {
                this.client.getTaskClient().cancelTask(task.getHref());
                this.waitForTask(task);
            }
            catch (TaskInErrorStateException e) {}
        }
        return this.client.getVAppClient().getVApp(vappId);
    }

    public void waitForTask(Task task) {
        if (!this.successTester.apply((Object)task.getHref())) {
            throw new TaskStillRunningException(task);
        }
    }

    public void rebootNode(String in) {
        URI id = URI.create((String)Preconditions.checkNotNull((Object)in, (Object)"node.id"));
        this.waitForTask(this.client.getVAppClient().resetVApp(id));
    }

    public void resumeNode(String in) {
        URI id = URI.create((String)Preconditions.checkNotNull((Object)in, (Object)"node.id"));
        this.waitForTask(this.client.getVAppClient().powerOnVApp(id));
    }

    public void suspendNode(String in) {
        URI id = URI.create((String)Preconditions.checkNotNull((Object)in, (Object)"node.id"));
        this.waitForTask(this.client.getVAppClient().powerOffVApp(id));
    }
}

