/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.handlers;

import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpMessage;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.HttpUtils;
import org.jclouds.logging.Logger;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.util.Strings2;
import org.jclouds.vcloud.VCloudResponseException;
import org.jclouds.vcloud.domain.VCloudError;
import org.jclouds.vcloud.util.VCloudUtils;

@Singleton
public class ParseVCloudErrorFromHttpResponse
implements HttpErrorHandler {
    @Resource
    protected Logger logger = Logger.NULL;
    public static final Pattern RESOURCE_PATTERN = Pattern.compile(".*/v[^/]+/([^/]+)/([0-9]+)");
    private final VCloudUtils utils;

    @Inject
    public ParseVCloudErrorFromHttpResponse(VCloudUtils utils) {
        this.utils = utils;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleError(HttpCommand command, HttpResponse response) {
        void var4_14;
        HttpRequest request = command.getCurrentRequest();
        HttpResponseException httpResponseException = new HttpResponseException(command, response);
        try {
            VCloudError error = null;
            String message = null;
            if (response.getPayload() != null) {
                try {
                    error = this.utils.parseErrorFromContent(request, response);
                    if (error != null) {
                        message = error.getMessage();
                        VCloudResponseException vCloudResponseException = new VCloudResponseException(command, response, error);
                    } else {
                        message = Strings2.toStringAndClose((InputStream)response.getPayload().getInput());
                        HttpResponseException httpResponseException2 = message != null ? new HttpResponseException(command, response, message) : httpResponseException;
                    }
                }
                catch (IOException e) {
                }
                finally {
                    response.getPayload().release();
                }
            }
            message = message != null ? message : String.format("%s -> %s", request.getRequestLine(), response.getStatusLine());
            switch (response.getStatusCode()) {
                case 400: {
                    void var4_8;
                    if (error != null && (error.getMinorErrorCode() != null && error.getMinorErrorCode() == VCloudError.MinorCode.BUSY_ENTITY || error.getMessage() != null && error.getMessage().indexOf("is not running") != -1)) {
                        IllegalStateException illegalStateException = new IllegalStateException(message, (Throwable)var4_8);
                        break;
                    }
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException(message, (Throwable)var4_8);
                    break;
                }
                case 401: 
                case 403: {
                    void var4_8;
                    if (error != null && (error.getMinorErrorCode() != null && error.getMinorErrorCode() == VCloudError.MinorCode.ACCESS_TO_RESOURCE_IS_FORBIDDEN || error.getMessage() != null && error.getMessage().indexOf("No access to entity") != -1)) {
                        ResourceNotFoundException resourceNotFoundException = new ResourceNotFoundException(message, (Throwable)var4_8);
                        break;
                    }
                    AuthorizationException authorizationException = new AuthorizationException(var4_8.getMessage(), (Throwable)var4_8);
                    break;
                }
                case 404: {
                    if (command.getCurrentRequest().getMethod().equals("DELETE")) break;
                    String path = command.getCurrentRequest().getEndpoint().getPath();
                    Matcher matcher = RESOURCE_PATTERN.matcher(path);
                    message = matcher.find() ? String.format("%s %s not found", matcher.group(1), matcher.group(2)) : path;
                    ResourceNotFoundException resourceNotFoundException = new ResourceNotFoundException(message);
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            HttpUtils.releasePayload((HttpMessage)response);
            command.setException((Exception)httpResponseException);
            throw throwable;
        }
        HttpUtils.releasePayload((HttpMessage)response);
        command.setException((Exception)var4_14);
    }
}

