/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.options;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Set;
import org.jclouds.vcloud.domain.network.NetworkConfig;

public class InstantiateVAppTemplateOptions {
    private Set<NetworkConfig> networkConfig = Sets.newLinkedHashSet();
    private Boolean customizeOnInstantiate;
    private String description = null;
    private boolean deploy = true;
    private boolean powerOn = true;

    public String getDescription() {
        return this.description;
    }

    public boolean shouldDeploy() {
        return this.deploy;
    }

    public boolean shouldPowerOn() {
        return this.powerOn;
    }

    public InstantiateVAppTemplateOptions description(String description) {
        this.description = description;
        return this;
    }

    public InstantiateVAppTemplateOptions deploy(boolean deploy) {
        this.deploy = deploy;
        return this;
    }

    public InstantiateVAppTemplateOptions powerOn(boolean powerOn) {
        this.powerOn = powerOn;
        return this;
    }

    public InstantiateVAppTemplateOptions addNetworkConfig(NetworkConfig networkConfig) {
        this.networkConfig.add((NetworkConfig)Preconditions.checkNotNull((Object)networkConfig, (Object)"networkConfig"));
        return this;
    }

    public Set<NetworkConfig> getNetworkConfig() {
        return this.networkConfig;
    }

    public String toString() {
        return "[networkConfig=" + this.networkConfig + ", customizeOnInstantiate=" + this.customizeOnInstantiate + ", description=" + this.description + ", deploy=" + this.deploy + ", powerOn=" + this.powerOn + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.customizeOnInstantiate == null ? 0 : this.customizeOnInstantiate.hashCode());
        result = 31 * result + (this.deploy ? 1231 : 1237);
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.networkConfig == null ? 0 : ((Object)this.networkConfig).hashCode());
        result = 31 * result + (this.powerOn ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InstantiateVAppTemplateOptions other = (InstantiateVAppTemplateOptions)obj;
        if (this.customizeOnInstantiate == null ? other.customizeOnInstantiate != null : !this.customizeOnInstantiate.equals(other.customizeOnInstantiate)) {
            return false;
        }
        if (this.deploy != other.deploy) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.networkConfig == null ? other.networkConfig != null : !((Object)this.networkConfig).equals(other.networkConfig)) {
            return false;
        }
        return this.powerOn == other.powerOn;
    }

    public static class Builder {
        public static InstantiateVAppTemplateOptions description(String description) {
            InstantiateVAppTemplateOptions options = new InstantiateVAppTemplateOptions();
            return options.description(description);
        }

        public static InstantiateVAppTemplateOptions deploy(boolean deploy) {
            InstantiateVAppTemplateOptions options = new InstantiateVAppTemplateOptions();
            return options.deploy(deploy);
        }

        public static InstantiateVAppTemplateOptions powerOn(boolean powerOn) {
            InstantiateVAppTemplateOptions options = new InstantiateVAppTemplateOptions();
            return options.powerOn(powerOn);
        }

        public static InstantiateVAppTemplateOptions addNetworkConfig(NetworkConfig networkConfig) {
            InstantiateVAppTemplateOptions options = new InstantiateVAppTemplateOptions();
            return options.addNetworkConfig(networkConfig);
        }
    }
}

